/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.expression;

import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.privileged.expression.ExpressionConfig;

public class ExpressionArgument
extends AbstractComponent {
    private ExpressionConfig expressionConfig = new ExpressionConfig();
    private String name;
    private boolean optional;
    private Class<?> returnClass;
    protected ClassLoader expressionEvaluationClassLoader = ExpressionArgument.class.getClassLoader();
    @Inject
    private MuleContext muleContext;

    public ExpressionArgument() {
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional) {
        this(name, expressionConfig, optional, null);
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional, Class<?> returnClass) {
        this.expressionConfig = expressionConfig;
        this.name = name;
        this.optional = optional;
        this.returnClass = returnClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpressionConfig getExpressionConfig() {
        return this.expressionConfig;
    }

    public void setExpressionConfig(ExpressionConfig expressionConfig) {
        this.expressionConfig = expressionConfig;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    protected String getFullExpression() {
        return this.expressionConfig.getFullExpression();
    }

    protected void validate() {
        this.expressionConfig.validate();
    }

    public Object evaluate(CoreEvent event) throws ExpressionRuntimeException {
        Object result = ClassUtils.withContextClassLoader(this.expressionEvaluationClassLoader, () -> this.muleContext.getExpressionManager().evaluate(this.getExpression(), event).getValue());
        if (this.getReturnClass() != null && result != null && !this.getReturnClass().isInstance(result)) {
            try {
                Transformer t = ((MuleContextWithRegistries)this.muleContext).getRegistry().lookupTransformer(DataType.fromObject(result), DataType.fromType(this.getReturnClass()));
                result = t.transform(result);
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(CoreMessages.transformUnexpectedType(result.getClass(), this.getReturnClass()), (Throwable)e);
            }
        }
        return result;
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public void setReturnDataType(Class<?> returnClass) {
        this.returnClass = returnClass;
    }

    public void setExpressionEvaluationClassLoader(ClassLoader expressionEvaluationClassLoader) {
        this.expressionEvaluationClassLoader = expressionEvaluationClassLoader;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

