/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.component;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public abstract class AbstractExecutableComponent
extends AbstractComponent
implements ExecutableComponent {
    @Inject
    protected MuleContext muleContext;

    @Override
    public final CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
        MonoProcessor monoProcessor = MonoProcessor.create();
        CoreEvent.Builder builder = CoreEvent.builder(this.createEventContext((Publisher<Void>)monoProcessor));
        CoreEvent event = builder.message(inputEvent.getMessage()).error(inputEvent.getError().orElse(null)).variables(inputEvent.getVariables()).build();
        return Mono.from(MessageProcessors.process(event, this.getExecutableFunction())).onErrorMap(throwable -> {
            MessagingException messagingException = (MessagingException)throwable;
            CoreEvent messagingExceptionEvent = messagingException.getEvent();
            return new ComponentExecutionException(messagingExceptionEvent.getError().get().getCause(), messagingExceptionEvent);
        }).map(result -> new ExecutionResultImplementation((Event)result, monoProcessor)).toFuture();
    }

    @Override
    public final CompletableFuture<Event> execute(Event event) {
        BaseEventContext child = this.createChildEventContext(event.getContext());
        CoreEvent internalEvent = event instanceof CoreEvent ? CoreEvent.builder(child, (CoreEvent)event).build() : CoreEvent.builder(this.createEventContext((Publisher<Void>)Mono.empty())).message(event.getMessage()).error(event.getError().orElse(null)).variables(event.getVariables()).build();
        return Mono.from(MessageProcessors.process(internalEvent, this.getExecutableFunction())).onErrorMap(throwable -> {
            MessagingException messagingException = (MessagingException)throwable;
            CoreEvent messagingExceptionEvent = messagingException.getEvent();
            return new ComponentExecutionException(messagingExceptionEvent.getError().get().getCause(), messagingExceptionEvent);
        }).map(r -> CoreEvent.builder(event.getContext(), r).build()).cast(Event.class).toFuture();
    }

    protected EventContext createEventContext(Publisher<Void> externalCompletionPublisher) {
        return EventContextFactory.create(this.muleContext.getUniqueIdString(), this.muleContext.getId(), this.getLocation(), null, externalCompletionPublisher, NullExceptionHandler.getInstance());
    }

    protected BaseEventContext createChildEventContext(EventContext parent) {
        return DefaultEventContext.child((BaseEventContext)parent, Optional.ofNullable(this.getLocation()));
    }

    protected ReactiveProcessor getExecutableFunction() {
        if (this instanceof ReactiveProcessor) {
            return (ReactiveProcessor)((Object)this);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Method getExecutableFunction not redefined and instance %s is not of type ReactiveProcessor", this)));
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private static class ExecutionResultImplementation
    implements ExecutionResult {
        private Event result;
        private MonoProcessor complete;

        private ExecutionResultImplementation(Event result, MonoProcessor complete) {
            this.result = result;
            this.complete = complete;
        }

        @Override
        public Event getEvent() {
            return this.result;
        }

        @Override
        public void complete() {
            this.complete.onComplete();
        }
    }
}

