/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax.resolver;

import java.util.HashMap;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;

public class DefaultImportTypesStrategy
implements ImportTypesStrategy {
    private final ExtensionModel extensionModel;
    private final DslResolvingContext context;
    private final Map<MetadataType, XmlDslModel> importedTypes;

    public DefaultImportTypesStrategy(ExtensionModel extensionModel, DslResolvingContext context) {
        this.extensionModel = extensionModel;
        this.context = context;
        this.importedTypes = this.generateImportedTypes();
    }

    private Map<MetadataType, XmlDslModel> generateImportedTypes() {
        HashMap<MetadataType, XmlDslModel> types = new HashMap<MetadataType, XmlDslModel>();
        this.extensionModel.getImportedTypes().stream().map(ImportedTypeModel::getImportedType).forEach(importedType -> importedType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).ifPresent(typeId -> {
            ExtensionModel extensionModel = this.context.getExtensionForType((String)typeId).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't load type '%s' because its declaring extension wasn't present in the current context", typeId)));
            types.put((MetadataType)importedType, extensionModel.getXmlDslModel());
        }));
        return types;
    }

    @Override
    public Map<MetadataType, XmlDslModel> getImportedTypes() {
        return this.importedTypes;
    }
}

