/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class OAuthDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        private final MetadataType stringType = this.typeLoader.load((Type)((Object)String.class));

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            final ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            new IdempotentDeclarationWalker(){

                @Override
                protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                    declaration.getModelProperty(OAuthModelProperty.class).ifPresent(property -> EnricherDelegate.this.enrich(extensionDeclaration, declaration, property.getGrantTypes()));
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }

        private void enrich(ExtensionDeclaration extension, ConnectionProviderDeclaration declaration, List<OAuthGrantType> grantTypes) {
            grantTypes.forEach(type -> {
                if (!"Authorization Code".equals(type.getName())) {
                    throw new IllegalConnectionProviderModelDefinitionException(String.format("Extension '%s' defines connection provider '%s' with unsupported OAuth GrantType '%s'", extension.getName(), declaration.getName(), type.getName()));
                }
                this.addOAuthAuthorizationCodeParameters(declaration, (AuthorizationCodeGrantType)type);
                this.addOAuthCallbackParameters(declaration);
                this.addOAuthStoreConfigParameter(declaration);
            });
        }

        private void addOAuthAuthorizationCodeParameters(ConnectionProviderDeclaration declaration, AuthorizationCodeGrantType grantType) {
            LinkedList<ParameterDeclaration> params = new LinkedList<ParameterDeclaration>();
            params.add(this.buildParameter("consumerKey", "The OAuth consumerKey as registered with the service provider", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            params.add(this.buildParameter("consumerSecret", "The OAuth consumerSecret as registered with the service provider", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            params.add(this.buildParameter("authorizationUrl", "The service provider's authorization endpoint URL", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getAuthorizationUrl()));
            params.add(this.buildParameter("accessTokenUrl", "The service provider's accessToken endpoint URL", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getAccessTokenUrl()));
            params.add(this.buildParameter("scopes", "The OAuth scopes to be requested during the dance. If not provided, it will default to those in the annotation", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getDefaultScope().orElse(null)));
            params.add(this.buildParameter("resourceOwnerId", "The resourceOwnerId which each component should use if it doesn't reference otherwise.", false, this.stringType, ExpressionSupport.SUPPORTED, null));
            params.add(this.buildParameter("before", "The name of a flow to be executed right before starting the OAuth dance", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            params.add(this.buildParameter("after", "The name of a flow to be executed right after an accessToken has been received", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            this.addToGroup(params, "oauthAuthorizationCode", declaration);
        }

        private void addOAuthCallbackParameters(ConnectionProviderDeclaration declaration) {
            LinkedList<ParameterDeclaration> params = new LinkedList<ParameterDeclaration>();
            ParameterDeclaration listenerConfig = this.buildParameter("listenerConfig", "A reference to a <http:listener-config /> to be used in order to create the listener that will catch the access token callback endpoint.", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null);
            listenerConfig.setAllowedStereotypeModels(Collections.singletonList(StereotypeModelBuilder.newStereotype("listener-config", "http").withParent(MuleStereotypes.CONFIG).build()));
            params.add(listenerConfig);
            params.add(this.buildParameter("callbackPath", "The path of the access token callback endpoint", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            params.add(this.buildParameter("authorizePath", "The path of the local http endpoint which triggers the OAuth dance", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            params.add(this.buildParameter("externalCallbackUrl", "If the callback endpoint is behind a proxy or should be accessed through a non direct URL, use this parameter to tell the OAuth provider the URL it should use to access the callback", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null));
            this.addToGroup(params, "oauthCallbackConfig", declaration);
        }

        private void addToGroup(List<ParameterDeclaration> params, String groupName, ConnectionProviderDeclaration declaration) {
            ParameterGroupDeclaration group = declaration.getParameterGroup(groupName);
            params.forEach(group::addParameter);
            group.showInDsl(true);
        }

        private void addOAuthStoreConfigParameter(ConnectionProviderDeclaration declaration) {
            ParameterDeclaration osParameter = this.buildParameter("objectStore", "A reference to the object store that should be used to store each resource owner id's data. If not specified, runtime will automatically provision the default one.", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null);
            osParameter.setAllowedStereotypeModels(Collections.singletonList(MuleStereotypes.OBJECT_STORE));
            this.addToGroup(Arrays.asList(osParameter), "oauthStoreConfig", declaration);
        }

        private ParameterDeclaration buildParameter(String name, String description, boolean required, MetadataType type, ExpressionSupport expressionSupport, Object defaultValue) {
            ParameterDeclaration parameter = new ParameterDeclaration(name);
            parameter.setDescription(description);
            parameter.setExpressionSupport(expressionSupport);
            parameter.setRequired(required);
            parameter.setDefaultValue(defaultValue);
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(type, false);
            return parameter;
        }
    }
}

