/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.DeploymentStopException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStartedSplashScreen;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStatusMapper;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.service.ServiceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleApplication
implements Application {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ApplicationDescriptor descriptor;
    private final DomainRepository domainRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final File location;
    private ApplicationStatus status;
    protected ArtifactClassLoader deploymentClassLoader;
    protected MuleContextListener muleContextListener;
    private NotificationListener<MuleContextNotification> statusListener;
    private ArtifactContext artifactContext;
    private ApplicationPolicyProvider policyManager;
    private NotificationListenerRegistry notificationRegistrer;

    public DefaultMuleApplication(ApplicationDescriptor descriptor, MuleDeployableArtifactClassLoader deploymentClassLoader, List<ArtifactPlugin> artifactPlugins, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, File location, ClassLoaderRepository classLoaderRepository, ApplicationPolicyProvider applicationPolicyProvider) {
        this.descriptor = descriptor;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.artifactPlugins = artifactPlugins;
        this.location = location;
        this.deploymentClassLoader = deploymentClassLoader;
        this.policyManager = applicationPolicyProvider;
        this.updateStatusFor("not in lifecycle");
        if (deploymentClassLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
    }

    @Override
    public void setMuleContextListener(MuleContextListener muleContextListener) {
        Preconditions.checkArgument(muleContextListener != null, "setMuleContextListener cannot be null");
        this.muleContextListener = muleContextListener;
    }

    @Override
    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("New app '%s'", this.descriptor.getName())));
        }
        this.updateStatusFor("not in lifecycle");
        try {
            for (String configFile : this.descriptor.getConfigResources()) {
                URL configFileUrl = this.getArtifactClassLoader().getClassLoader().getResource(configFile);
                if (configFileUrl != null) continue;
                String message = String.format("Config for app '%s' not found: %s", this.getArtifactName(), configFile);
                throw new InstallException(I18nMessageFactory.createStaticMessage(message));
            }
        }
        catch (Exception e) {
            this.setStatusToFailed();
            throw e;
        }
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Domain getDomain() {
        Optional<BundleDescriptor> domainBundleDescriptor = this.descriptor.getDomainDescriptor();
        if (domainBundleDescriptor.isPresent()) {
            return this.domainRepository.getDomain(domainBundleDescriptor.get().getArtifactFileName());
        }
        return this.domainRepository.getDomain("default");
    }

    @Override
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Starting app '%s'", this.descriptor.getName())));
        }
        try {
            this.artifactContext.getMuleContext().start();
            ClassUtils.withContextClassLoader(null, () -> {
                ApplicationStartedSplashScreen splashScreen = new ApplicationStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                this.logger.info(splashScreen.toString());
            });
        }
        catch (Exception e) {
            this.setStatusToFailed();
            if (e instanceof MuleException) {
                this.logger.error(((MuleException)e).getDetailedMessage());
            } else {
                this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new DeploymentStartException(I18nMessageFactory.createStaticMessage(String.format("Error starting application '%s'", this.descriptor.getName())), (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.doInit(false, false);
    }

    private void doInit(boolean lazy, boolean disableXmlValidations) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Initializing app '%s'", this.descriptor.getName())));
        }
        try {
            ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactProperties(this.descriptor.getAppProperties()).setArtifactType(ArtifactType.APP).setArtifactName(this.descriptor.getName()).setArtifactInstallationDirectory(this.descriptor.getArtifactLocation()).setConfigurationFiles(this.descriptor.getConfigResources().toArray(new String[this.descriptor.getConfigResources().size()])).setDefaultEncoding(this.descriptor.getEncoding()).setArtifactPlugins(this.artifactPlugins).setExecutionClassloader(this.deploymentClassLoader.getClassLoader()).setEnableLazyInit(lazy).setDisableXmlValidations(disableXmlValidations).setServiceRepository(this.serviceRepository).setExtensionModelLoaderRepository(this.extensionModelLoaderRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactDeclaration(this.descriptor.getArtifactDeclaration()).setPolicyProvider(this.policyManager);
            Domain domain = this.descriptor.getDomainDescriptor().isPresent() ? this.domainRepository.getDomain(this.descriptor.getDomainDescriptor().get().getArtifactFileName()) : this.domainRepository.getDomain("default");
            if (domain.getRegistry() != null) {
                artifactBuilder.serParenArtifact(domain);
            }
            if (this.muleContextListener != null) {
                artifactBuilder.setMuleContextListener(this.muleContextListener);
            }
            this.artifactContext = artifactBuilder.build();
            this.setMuleContext(this.artifactContext.getMuleContext(), this.artifactContext.getRegistry());
        }
        catch (Exception e) {
            this.setStatusToFailed();
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage(ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    @Override
    public void lazyInit() {
        this.doInit(true, true);
    }

    @Override
    public void lazyInit(boolean disableXmlValidations) {
        this.doInit(true, disableXmlValidations);
    }

    protected void setArtifactContext(ArtifactContext artifactContext) {
        this.artifactContext = artifactContext;
        this.setMuleContext(artifactContext.getMuleContext(), artifactContext.getRegistry());
    }

    private void setMuleContext(final MuleContext muleContext, Registry registry) {
        this.statusListener = new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public boolean isBlocking() {
                return false;
            }

            @Override
            public void onNotification(MuleContextNotification notification) {
                IntegerAction action = notification.getAction();
                if (new IntegerAction(102).equals(action) || new IntegerAction(104).equals(action) || new IntegerAction(106).equals(action) || new IntegerAction(108).equals(action)) {
                    DefaultMuleApplication.this.updateStatusFor(muleContext.getLifecycleManager().getCurrentPhase());
                }
            }
        };
        this.notificationRegistrer = registry.lookupByType(NotificationListenerRegistry.class).get();
        this.notificationRegistrer.registerListener(this.statusListener);
    }

    private void updateStatusFor(String phase) {
        this.status = ApplicationStatusMapper.getApplicationStatus(phase);
    }

    private void setStatusToFailed() {
        if (this.artifactContext != null) {
            this.notificationRegistrer.unregisterListener(this.statusListener);
        }
        this.status = ApplicationStatus.DEPLOYMENT_FAILED;
    }

    @Override
    public Registry getRegistry() {
        return this.artifactContext != null ? this.artifactContext.getRegistry() : null;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        return (ConnectivityTestingService)this.artifactContext.getRegistry().lookupByName("_muleConnectivityTestingService").get();
    }

    @Override
    public MetadataService getMetadataService() {
        return (MetadataService)this.artifactContext.getRegistry().lookupByName("_muleMetadataService").get();
    }

    @Override
    public ValueProviderService getValueProviderService() {
        return (ValueProviderService)this.artifactContext.getRegistry().lookupByName("_muleValueProviderService").get();
    }

    @Override
    public void dispose() {
        try {
            ClassLoader appCl = null;
            if (this.getArtifactClassLoader() != null) {
                appCl = this.getArtifactClassLoader().getClassLoader();
            }
            if (appCl != null) {
                Thread.currentThread().setContextClassLoader(appCl);
            }
            this.doDispose();
            if (appCl != null) {
                if (DefaultMuleApplication.isRegionClassLoaderMember(appCl)) {
                    ((DisposableClassLoader)((Object)appCl.getParent())).dispose();
                } else if (appCl instanceof DisposableClassLoader) {
                    ((DisposableClassLoader)((Object)appCl)).dispose();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
            this.deploymentClassLoader = null;
        }
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.deploymentClassLoader.getArtifactId();
    }

    @Override
    public File[] getResourceFiles() {
        return this.descriptor.getConfigResources().stream().map(configFile -> new File(this.getLocation(), (String)configFile)).collect(Collectors.toList()).toArray(new File[this.descriptor.getConfigResources().size()]);
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    @Override
    public void stop() {
        if (this.artifactContext == null || !this.artifactContext.getMuleContext().getLifecycleManager().isDirectTransition("stop")) {
            return;
        }
        if (this.artifactContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Stopping app '%s' with no mule context", this.descriptor.getName()));
            }
            this.status = ApplicationStatus.STOPPED;
            return;
        }
        this.artifactContext.getMuleContext().getLifecycleManager().checkPhase("stop");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(SplashScreen.miniSplash(String.format("Stopping app '%s'", this.descriptor.getName())));
            }
            this.artifactContext.getMuleContext().stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(I18nMessageFactory.createStaticMessage(String.format("Error stopping application '%s'", this.descriptor.getName())), (Throwable)e);
        }
    }

    @Override
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @Override
    public RegionClassLoader getRegionClassLoader() {
        ClassLoader parentClassLoader = this.deploymentClassLoader.getClassLoader().getParent();
        if (parentClassLoader instanceof RegionClassLoader) {
            return (RegionClassLoader)parentClassLoader;
        }
        throw new IllegalStateException("Application is not a region owner");
    }

    @Override
    public ApplicationPolicyProvider getPolicyManager() {
        return this.policyManager;
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.descriptor.getName(), Integer.toHexString(System.identityHashCode(this)));
    }

    protected void doDispose() {
        if (this.artifactContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("App '%s' never started, nothing to dispose of", this.descriptor.getName()));
            }
            return;
        }
        try {
            this.stop();
        }
        catch (DeploymentStopException e) {
            this.logger.error("Error stopping application", (Throwable)e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Disposing app '%s'", this.descriptor.getName())));
        }
        this.artifactContext.getMuleContext().dispose();
        this.artifactContext = null;
    }
}

