/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.ExtensionModelDiscoverer;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;

public class ArtifactExtensionManagerFactory
implements ExtensionManagerFactory {
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins = new ArrayList<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>>();
    private final ExtensionManagerFactory extensionManagerFactory;
    private final ExtensionModelDiscoverer extensionModelDiscoverer;

    public ArtifactExtensionManagerFactory(List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository, ExtensionManagerFactory extensionManagerFactory) {
        artifactPlugins.forEach(artifactPlugin -> this.artifactPlugins.add(new Pair(artifactPlugin.getDescriptor(), artifactPlugin.getArtifactClassLoader())));
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.extensionManagerFactory = extensionManagerFactory;
        this.extensionModelDiscoverer = new ExtensionModelDiscoverer();
    }

    @Override
    public ExtensionManager create(MuleContext muleContext) {
        ExtensionManager extensionManager = this.extensionManagerFactory.create(muleContext);
        HashSet extensions = new HashSet();
        extensions.addAll(this.extensionModelDiscoverer.discoverExtensionModels(this.extensionModelLoaderRepository, this.artifactPlugins).stream().map(Pair::getSecond).collect(Collectors.toSet()));
        extensions.forEach(extensionManager::registerExtension);
        return extensionManager;
    }
}

