/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.internal.config.StartupContext;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeployerMonitorThreadFactory;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementRemovedEvent;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDirectoryWatcher
implements Runnable {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final String CHANGE_CHECK_INTERVAL_PROPERTY = "mule.launcher.changeCheckInterval";
    public static final IOFileFilter JAR_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".jar", IOCase.INSENSITIVE), FileFileFilter.FILE);
    public static final IOFileFilter ZIP_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".zip", IOCase.INSENSITIVE), FileFileFilter.FILE);
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock deploymentLock;
    private final ArchiveDeployer<Domain> domainArchiveDeployer;
    protected final ArchiveDeployer<Application> applicationArchiveDeployer;
    protected final Supplier<SchedulerService> schedulerServiceSupplier;
    private final ArtifactTimestampListener<Application> applicationTimestampListener;
    private final ArtifactTimestampListener<Domain> domainTimestampListener;
    private final ObservableList<Application> applications;
    private final ObservableList<Domain> domains;
    private final DomainBundleArchiveDeployer domainBundleDeployer;
    private final File appsDir;
    private final File domainsDir;
    private ScheduledExecutorService artifactDirMonitorTimer;
    protected volatile boolean dirty;

    public DeploymentDirectoryWatcher(DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<Domain> domainArchiveDeployer, ArchiveDeployer<Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock) {
        this.domainBundleDeployer = domainBundleDeployer;
        this.appsDir = applicationArchiveDeployer.getDeploymentDirectory();
        this.domainsDir = domainArchiveDeployer.getDeploymentDirectory();
        this.deploymentLock = deploymentLock;
        this.domainArchiveDeployer = domainArchiveDeployer;
        this.applicationArchiveDeployer = applicationArchiveDeployer;
        this.applications = applications;
        this.domains = domains;
        applications.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        domains.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        this.schedulerServiceSupplier = schedulerServiceSupplier;
        this.applicationTimestampListener = new ArtifactTimestampListener<Application>(applications);
        this.domainTimestampListener = new ArtifactTimestampListener<Domain>(domains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.deploymentLock.lock();
        this.deleteAllAnchors();
        Map<String, Object> options = StartupContext.get().getStartupOptions();
        String appString = (String)options.get("app");
        try {
            if (appString == null) {
                this.run();
                this.scheduleChangeMonitor();
            } else {
                String[] explodedDomains = this.domainsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] packagedDomains = this.domainsDir.list((FilenameFilter)JAR_ARTIFACT_FILTER);
                this.deployPackedDomains(packagedDomains);
                this.deployExplodedDomains(explodedDomains);
                String[] apps = appString.split(":");
                for (String app : apps = this.removeDuplicateAppNames(apps)) {
                    try {
                        File applicationFile = new File(this.appsDir, app + ".jar");
                        if (applicationFile.exists() && applicationFile.isFile()) {
                            this.applicationArchiveDeployer.deployPackagedArtifact(app + ".jar");
                            continue;
                        }
                        if (!this.applicationArchiveDeployer.isUpdatedZombieArtifact(app)) continue;
                        this.applicationArchiveDeployer.deployExplodedArtifact(app);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(SplashScreen.miniSplash("Mule is up and running in a fixed app set mode"));
                }
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public void stop() {
        this.stopAppDirMonitorTimer();
        this.deploymentLock.lock();
        try {
            this.stopArtifacts(this.applications);
            this.stopArtifacts(this.domains);
        }
        finally {
            this.deploymentLock.unlock();
        }
    }

    private void stopArtifacts(List<? extends DeployableArtifact> artifacts) {
        Collections.reverse(artifacts);
        for (DeployableArtifact deployableArtifact : artifacts) {
            try {
                deployableArtifact.stop();
                deployableArtifact.dispose();
            }
            catch (Throwable t) {
                this.logger.error("Error stopping artifact {}", (Object)deployableArtifact.getArtifactName(), (Object)t);
            }
        }
    }

    private static int getChangesCheckIntervalMs() {
        try {
            String value = System.getProperty(CHANGE_CHECK_INTERVAL_PROPERTY);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    private void scheduleChangeMonitor() {
        int reloadIntervalMs = DeploymentDirectoryWatcher.getChangesCheckIntervalMs();
        this.artifactDirMonitorTimer = Executors.newSingleThreadScheduledExecutor(new ArtifactDeployerMonitorThreadFactory());
        this.artifactDirMonitorTimer.scheduleWithFixedDelay(this, reloadIntervalMs, reloadIntervalMs, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Mule is up and kicking (every %dms)", reloadIntervalMs)));
        }
    }

    protected void deployPackedApps(String[] zips) {
        for (String zip : zips) {
            try {
                this.applicationArchiveDeployer.deployPackagedArtifact(zip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void deployExplodedApps(String[] apps) {
        for (String addedApp : apps) {
            try {
                this.applicationArchiveDeployer.deployExplodedArtifact(addedApp);
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking for changes...");
            }
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: " + ((DebuggableReentrantLock)this.deploymentLock).getOwner());
                }
                return;
            }
            this.undeployRemovedApps();
            this.undeployRemovedDomains();
            this.deployDomainBundles();
            String[] domains = this.domainsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] domainZips = this.domainsDir.list((FilenameFilter)JAR_ARTIFACT_FILTER);
            this.redeployModifiedDomains();
            this.deployPackedDomains(domainZips);
            if (domainZips.length > 0 || this.dirty) {
                domains = this.domainsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            this.deployExplodedDomains(domains);
            this.redeployModifiedApplications();
            String[] apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] appZips = this.appsDir.list((FilenameFilter)JAR_ARTIFACT_FILTER);
            this.deployPackedApps(appZips);
            if (appZips.length > 0 || this.dirty) {
                apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            this.deployExplodedApps(apps);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
            this.dirty = false;
        }
    }

    private void deployDomainBundles() {
        String[] domainBundles;
        for (String domainBundle : domainBundles = this.domainsDir.list((FilenameFilter)ZIP_ARTIFACT_FILTER)) {
            try {
                File domainBundleFile = new File(MuleFoldersUtil.getDomainsFolder(), domainBundle);
                this.domainBundleDeployer.deployArtifact(domainBundleFile.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public <T extends Artifact> T findArtifact(String artifactName, ObservableList<T> artifacts) {
        return (T)((Artifact)CollectionUtils.find(artifacts, (Predicate)new BeanPropertyValueEqualsPredicate("artifactName", (Object)artifactName)));
    }

    private void undeployRemovedDomains() {
        this.undeployRemovedArtifacts(this.domainsDir, this.domains, this.domainArchiveDeployer);
    }

    private void undeployRemovedApps() {
        this.undeployRemovedArtifacts(this.appsDir, this.applications, this.applicationArchiveDeployer);
    }

    private void undeployRemovedArtifacts(File artifactDir, ObservableList<? extends Artifact> artifacts, ArchiveDeployer<? extends Artifact> archiveDeployer) {
        String[] currentAnchors = artifactDir.list((FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX));
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Current anchors:%n", new Object[0]));
            for (String currentAnchor : currentAnchors) {
                sb.append(String.format("  %s%n", currentAnchor));
            }
            this.logger.debug(sb.toString());
        }
        String[] artifactAnchors = this.findExpectedAnchorFiles(artifacts);
        Collection deletedAnchors = CollectionUtils.subtract(Arrays.asList(artifactAnchors), Arrays.asList(currentAnchors));
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Deleted anchors:%n", new Object[0]));
            for (String deletedAnchor : deletedAnchors) {
                sb.append(String.format("  %s%n", deletedAnchor));
            }
            this.logger.debug(sb.toString());
        }
        for (String deletedAnchor : deletedAnchors) {
            String artifactName = StringUtils.removeEnd((String)deletedAnchor, (String)ARTIFACT_ANCHOR_SUFFIX);
            try {
                if (this.findArtifact(artifactName, artifacts) != null) {
                    archiveDeployer.undeployArtifact(artifactName);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.format("Artifact [%s] has already been undeployed via API", artifactName));
            }
            catch (Throwable t) {
                this.logger.error("Failed to undeployArtifact artifact: " + artifactName, t);
            }
        }
    }

    private String[] findExpectedAnchorFiles(ObservableList<? extends Artifact> artifacts) {
        String[] anchors = new String[artifacts.size()];
        int i = 0;
        for (Artifact artifact : artifacts) {
            anchors[i++] = artifact.getArtifactName() + ARTIFACT_ANCHOR_SUFFIX;
        }
        return anchors;
    }

    private void deployExplodedDomains(String[] domains) {
        for (String addedDomain : domains) {
            try {
                if (!this.domainArchiveDeployer.isUpdatedZombieArtifact(addedDomain)) continue;
                this.domainArchiveDeployer.deployExplodedArtifact(addedDomain);
            }
            catch (DeploymentException e) {
                this.logger.error("Error deploying domain '{}'", (Object)addedDomain, (Object)e);
            }
        }
    }

    private void deployPackedDomains(String[] zips) {
        for (String zip : zips) {
            try {
                this.domainArchiveDeployer.deployPackagedArtifact(zip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteAllAnchors() {
        this.deleteAnchorsFromDirectory(this.domainsDir);
        this.deleteAnchorsFromDirectory(this.appsDir);
    }

    private void deleteAnchorsFromDirectory(File directory) {
        String[] anchors;
        for (String anchor : anchors = directory.list((FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX))) {
            new File(directory, anchor).delete();
        }
    }

    private String[] removeDuplicateAppNames(String[] apps) {
        LinkedList<String> appNames = new LinkedList<String>();
        for (String appName : apps) {
            if (appNames.contains(appName)) continue;
            appNames.add(appName);
        }
        return appNames.toArray(new String[appNames.size()]);
    }

    private void redeployModifiedDomains() {
        Collection redeployableDomains = this.getArtifactsToRedeploy(this.domains);
        this.redeployModifiedArtifacts(redeployableDomains, this.domainTimestampListener, this.domainArchiveDeployer);
    }

    private void redeployModifiedApplications() {
        Collection redeployableApplications = this.getArtifactsToRedeploy(this.applications);
        this.redeployModifiedArtifacts(redeployableApplications, this.applicationTimestampListener, this.applicationArchiveDeployer);
    }

    private <T extends DeployableArtifact> Collection getArtifactsToRedeploy(Collection<T> collection) {
        return CollectionUtils.select(collection, object -> ((DeployableArtifactDescriptor)((DeployableArtifact)object).getDescriptor()).isRedeploymentEnabled());
    }

    private <T extends Artifact> void redeployModifiedArtifacts(Collection<T> artifacts, ArtifactTimestampListener<T> artifactTimestampListener, ArchiveDeployer<T> artifactArchiveDeployer) {
        for (Artifact artifact : artifacts) {
            if (!artifactTimestampListener.isArtifactResourceUpdated(artifact)) continue;
            try {
                artifactArchiveDeployer.redeploy(artifact);
            }
            catch (DeploymentException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error redeploying artifact {}", (Object)artifact.getArtifactName(), (Object)e);
            }
        }
    }

    private void stopAppDirMonitorTimer() {
        if (this.artifactDirMonitorTimer != null) {
            this.artifactDirMonitorTimer.shutdown();
            try {
                this.artifactDirMonitorTimer.awaitTermination(DeploymentDirectoryWatcher.getChangesCheckIntervalMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ArtifactResourcesTimestamp<T extends Artifact> {
        private final Map<String, Long> timestampsPerResource = new HashMap<String, Long>();

        public ArtifactResourcesTimestamp(Artifact artifact) {
            for (File configResourceFile : artifact.getResourceFiles()) {
                this.timestampsPerResource.put(configResourceFile.getAbsolutePath(), configResourceFile.lastModified());
            }
        }

        public boolean resourcesHaveSameTimestamp(T artifact) {
            boolean resourcesHaveSameTimestamp = true;
            for (File configResourceFile : artifact.getResourceFiles()) {
                long currentTimestamp;
                long originalTimestamp = this.timestampsPerResource.get(configResourceFile.getAbsolutePath());
                if (originalTimestamp == (currentTimestamp = configResourceFile.lastModified())) continue;
                this.timestampsPerResource.put(configResourceFile.getAbsolutePath(), currentTimestamp);
                resourcesHaveSameTimestamp = false;
            }
            return resourcesHaveSameTimestamp;
        }
    }

    private static class ArtifactTimestampListener<T extends Artifact>
    implements PropertyChangeListener {
        private Map<String, ArtifactResourcesTimestamp<T>> artifactConfigResourcesTimestaps = new HashMap<String, ArtifactResourcesTimestamp<T>>();

        public ArtifactTimestampListener(ObservableList<T> artifacts) {
            artifacts.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof ElementAddedEvent) {
                Artifact artifactAdded = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.put(artifactAdded.getArtifactName(), new ArtifactResourcesTimestamp(artifactAdded));
            } else if (event instanceof ElementRemovedEvent) {
                Artifact artifactRemoved = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.remove(artifactRemoved.getArtifactName());
            }
        }

        public boolean isArtifactResourceUpdated(T artifact) {
            ArtifactResourcesTimestamp<T> applicationResourcesTimestamp = this.artifactConfigResourcesTimestaps.get(artifact.getArtifactName());
            return !applicationResourcesTimestamp.resourcesHaveSameTimestamp(artifact);
        }
    }
}

