/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import java.util.HashMap;
import java.util.Map;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;

public abstract class AbstractExtensionObjectFactory<T>
extends AbstractComponentFactory<T>
implements ObjectTypeParametersResolver {
    protected final MuleContext muleContext;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected ParametersResolver parametersResolver;

    public AbstractExtensionObjectFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.parametersResolver = this.getParametersResolver(muleContext);
    }

    protected ParametersResolver getParametersResolver(MuleContext muleContext) {
        return ParametersResolver.fromValues(this.parameters, muleContext);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = this.normalize(parameters);
        this.parametersResolver = this.getParametersResolver(this.muleContext);
    }

    @Override
    public void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder) {
        this.parametersResolver.resolveParameterGroups(objectType, builder);
    }

    @Override
    public void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder) {
        this.parametersResolver.resolveParameters(objectType, builder);
    }

    private Map<String, Object> normalize(Map<String, Object> parameters) {
        HashMap<String, Object> normalized = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            String normalizedKey = key;
            if (this.isChildKey((String)key)) {
                normalizedKey = this.unwrapChildKey((String)key);
                normalized.put(normalizedKey, value);
            } else if (!normalized.containsKey(normalizedKey)) {
                normalized.put(normalizedKey, value);
            }
        });
        return normalized;
    }

    private boolean isChildKey(String key) {
        return key.startsWith("<<") && key.endsWith(">>");
    }

    private String unwrapChildKey(String key) {
        return key.replaceAll("<<", "").replaceAll(">>", "");
    }
}

