/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasFunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithFunctionContainers;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.function.ReflectiveFunctionExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class FunctionModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String FUNCTION = "Function";
    private final Map<MethodElement, FunctionDeclarer> functionDeclarers = new HashMap<MethodElement, FunctionDeclarer>();

    FunctionModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, WithFunctionContainers functionContainers) {
        functionContainers.getFunctionContainers().forEach(functionContainer -> this.declareFunctions(extensionDeclarer, declarer, (FunctionContainerElement)functionContainer));
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, FunctionContainerElement functionContainerElement) {
        this.declareFunctions(extensionDeclarer, declarer, functionContainerElement.getDeclaringClass(), functionContainerElement.getFunctions());
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, Class<?> methodOwnerClass, List<MethodElement> functions) {
        for (MethodElement methodElement : functions) {
            Class declaringClass = methodOwnerClass != null ? methodOwnerClass : methodElement.getDeclaringClass();
            this.checkIsNotAnExtension(declaringClass);
            Method method = methodElement.getMethod();
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(methodElement);
            if (configParameter.isPresent()) {
                throw new IllegalModelDefinitionException(String.format("Function '%s' requires a config parameter, but that is not allowed. Remove such parameter.", method.getName()));
            }
            HasFunctionDeclarer actualDeclarer = (HasFunctionDeclarer)((Object)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)((Object)declarer), configParameter, Optional.empty()));
            if (this.functionDeclarers.containsKey(methodElement)) {
                actualDeclarer.withFunction(this.functionDeclarers.get(methodElement));
                continue;
            }
            FunctionDeclarer function = actualDeclarer.withFunction(methodElement.getAlias()).withModelProperty(new ImplementingMethodModelProperty(method)).withModelProperty(new FunctionExecutorModelProperty(new ReflectiveFunctionExecutorFactory(declaringClass, method)));
            function.withOutput().ofType(IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader()));
            ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(FUNCTION, (NamedDeclaration)function.getDeclaration());
            this.loader.getMethodParametersLoader().declare(function, methodElement.getParameters(), declarationContext);
            this.functionDeclarers.put(methodElement, function);
        }
    }

    private void checkIsNotAnExtension(Class<?> type) {
        if (type.isAssignableFrom(this.getExtensionType()) || this.getExtensionType().isAssignableFrom(type)) {
            throw new IllegalOperationModelDefinitionException(String.format("Function class '%s' cannot be the same class (nor a derivative) of the extension class '%s", type.getName(), this.getExtensionType().getName()));
        }
    }
}

