/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.execution.InterceptableOperationExecutorWrapper;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReactiveOperationExecutionWrapper;

public final class OperationExecutorFactoryWrapper<T extends ComponentModel>
implements ComponentExecutorFactory<T>,
OperationArgumentResolverFactory<T> {
    private final ComponentExecutorFactory delegate;
    private final List<Interceptor> interceptors;

    public OperationExecutorFactoryWrapper(ComponentExecutorFactory<T> delegate, List<Interceptor> interceptors) {
        this.delegate = delegate;
        this.interceptors = interceptors;
    }

    @Override
    public ComponentExecutor<T> createExecutor(T operationModel) {
        ComponentExecutor<T> executor = this.delegate.createExecutor(operationModel);
        executor = new ReactiveOperationExecutionWrapper<T>(executor);
        executor = new InterceptableOperationExecutorWrapper<T>(executor, this.interceptors);
        return executor;
    }

    @Override
    public Function<ExecutionContext<T>, Map<String, Object>> createArgumentResolver(T operationModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)((Object)this.delegate)).createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

