/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public final class ExclusiveParameterGroupObjectBuilder<T>
extends DefaultObjectBuilder<T> {
    private final ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation;

    public ExclusiveParameterGroupObjectBuilder(Class<T> prototypeClass, ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation) {
        super(prototypeClass);
        this.exclusiveOptionalsTypeAnnotation = exclusiveOptionalsTypeAnnotation;
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        Collection definedExclusiveParameters = CollectionUtils.intersection(this.exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames(), (Collection)this.resolvers.keySet().stream().map(TypeUtils::getAlias).collect(Collectors.toSet()));
        if (definedExclusiveParameters.isEmpty() && this.exclusiveOptionalsTypeAnnotation.isOneRequired()) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Parameter group of type '%s' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [%s]", this.prototypeClass.getName(), Joiner.on((String)", ").join(this.exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames()))));
        }
        if (definedExclusiveParameters.size() > 1) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("In Parameter group of type '%s', the following parameters cannot be set at the same time: [%s]", this.prototypeClass.getName(), Joiner.on((String)", ").join((Iterable)definedExclusiveParameters))));
        }
        return super.build(context);
    }
}

