/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class SourceConfigurer {
    private final SourceModel model;
    private final ResolverSet resolverSet;
    private final MuleContext muleContext;

    public SourceConfigurer(SourceModel model, ResolverSet resolverSet, MuleContext muleContext) {
        this.model = model;
        this.resolverSet = resolverSet;
        this.muleContext = muleContext;
    }

    public Source configure(final Source source, Optional<ConfigurationInstance> config) throws MuleException {
        ResolverSetBasedObjectBuilder<Source> builder = new ResolverSetBasedObjectBuilder<Source>(source.getClass(), (ParameterizedModel)this.model, this.resolverSet){

            @Override
            protected Source instantiateObject() {
                return source;
            }

            @Override
            public Source build(ValueResolvingContext context) throws MuleException {
                Source source2 = (Source)this.build(this.resolverSet.resolve(context));
                IntrospectionUtils.injectDefaultEncoding(SourceConfigurer.this.model, source2, SourceConfigurer.this.muleContext.getConfiguration().getDefaultEncoding());
                return source2;
            }
        };
        try {
            return (Source)builder.build(ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent(this.muleContext), config));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception was found trying to configure source of type " + source.getClass().getName()), (Throwable)e);
        }
    }
}

