/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.impl.service.client.CompositeTransportCustomizer;
import org.mule.service.http.impl.service.client.CustomTimeoutThrottleRequestFilter;
import org.mule.service.http.impl.service.client.IOStrategyTransportCustomizer;
import org.mule.service.http.impl.service.client.LoggerTransportCustomizer;
import org.mule.service.http.impl.service.client.SocketConfigTransportCustomizer;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int DEFAULT_SELECTOR_THREAD_COUNT = Integer.getInteger(GrizzlyHttpClient.class.getName() + ".DEFAULT_SELECTOR_THREAD_COUNT", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final boolean streamingEnabled;
    private final int responseBufferSize;
    private final String name;
    private Scheduler selectorScheduler;
    private Scheduler workerScheduler;
    private final SchedulerService schedulerService;
    private final SchedulerConfig schedulersConfig;
    private AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;
    private final TlsContextFactory defaultTlsContextFactory = TlsContextFactory.builder().buildDefault();
    public static final String HOST_SEPARATOR = ",";

    public GrizzlyHttpClient(HttpClientConfiguration config, SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.streamingEnabled = config.isStreaming();
        this.responseBufferSize = config.getResponseBufferSize();
        this.name = config.getName();
        this.schedulerService = schedulerService;
        this.schedulersConfig = schedulersConfig;
    }

    @Override
    public void start() {
        this.selectorScheduler = this.schedulerService.customScheduler(this.schedulersConfig.withMaxConcurrentTasks(DEFAULT_SELECTOR_THREAD_COUNT).withName(this.name), Integer.MAX_VALUE);
        this.workerScheduler = this.schedulerService.ioScheduler(this.schedulersConfig);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) {
        TlsContextFactory resolvedTlsContextFactory;
        if (this.tlsContextFactory != null) {
            resolvedTlsContextFactory = this.tlsContextFactory;
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Cannot initialize SSL context"), (Throwable)e);
            }
            builder.setSSLContext(this.sslContext);
            TlsContextTrustStoreConfiguration trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration();
            if (trustStoreConfiguration != null && trustStoreConfiguration.isInsecure()) {
                logger.warn(String.format("TLS configuration for client %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.name));
                builder.setAcceptAnyCertificate(true);
            }
        } else {
            resolvedTlsContextFactory = this.defaultTlsContextFactory;
        }
        if (resolvedTlsContextFactory.getEnabledCipherSuites() != null) {
            builder.setEnabledCipherSuites(resolvedTlsContextFactory.getEnabledCipherSuites());
        }
        if (resolvedTlsContextFactory.getEnabledProtocols() != null) {
            builder.setEnabledProtocols(resolvedTlsContextFactory.getEnabledProtocols());
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty(proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof ProxyConfig.NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((ProxyConfig.NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        if (proxyConfig.getNonProxyHosts() != null && !proxyConfig.getNonProxyHosts().isEmpty()) {
            for (String host : proxyConfig.getNonProxyHosts().split(HOST_SEPARATOR)) {
                proxyServer.addNonProxyHost(host.trim());
            }
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer(this.selectorScheduler, this.workerScheduler, DEFAULT_SELECTOR_THREAD_COUNT));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer());
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
            builder.setConnectTimeout(this.clientSocketProperties.getConnectionTimeout().intValue());
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)Boolean.FALSE);
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    @Override
    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
        if (this.streamingEnabled) {
            return this.sendAndDefer(request, responseTimeout, followRedirects, authentication);
        }
        return this.sendAndWait(request, responseTimeout, followRedirects, authentication);
    }

    public HttpResponse sendAndDefer(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe, this.responseBufferSize);
        BodyDeferringAsyncHandler asyncHandler = new BodyDeferringAsyncHandler((OutputStream)outPipe);
        this.asyncHttpClient.executeRequest(grizzlyRequest, (AsyncHandler)asyncHandler);
        try {
            Response response = asyncHandler.getResponse();
            return this.createMuleResponse(response, inPipe);
        }
        catch (IOException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public HttpResponse sendAndWait(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            Response response = (Response)future.get();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            return this.createMuleResponse(response, response.getResponseBodyAsStream());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        try {
            Object asyncHandler = this.streamingEnabled ? new ResponseBodyDeferringAsyncHandler(future, new PipedOutputStream()) : new ResponseAsyncHandler(future);
            this.asyncHttpClient.executeRequest(this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication), (AsyncHandler)asyncHandler);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private HttpResponse createMuleResponse(Response response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        responseBuilder.statusCode(response.getStatusCode());
        responseBuilder.reasonPhrase(response.getStatusText());
        String contentType = response.getHeader("Content-Type".toLowerCase());
        String contentLength = response.getHeader("Content-Length".toLowerCase());
        responseBuilder.entity(this.createEntity(inputStream, contentType, contentLength));
        if (response.hasResponseHeaders()) {
            for (String header : response.getHeaders().keySet()) {
                for (String headerValue : response.getHeaders(header)) {
                    responseBuilder.addHeader(header, headerValue);
                }
            }
        }
        return responseBuilder.build();
    }

    private HttpEntity createEntity(InputStream stream, String contentType, String contentLength) {
        Long contentLengthAsLong = -1L;
        if (contentLength != null) {
            contentLengthAsLong = Long.parseLong(contentLength);
        }
        if (contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType())) {
            if (contentLengthAsLong >= 0L) {
                return new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong);
            }
            return new StreamedMultipartHttpEntity(stream, contentType);
        }
        if (contentLengthAsLong > 0L) {
            return new InputStreamHttpEntity(stream, contentLengthAsLong);
        }
        if (contentLengthAsLong == 0L) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity(stream);
    }

    private Request createGrizzlyRequest(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException {
        RequestBuilder reqBuilder = this.createRequestBuilder(request, builder -> {
            builder.setMethod(request.getMethod());
            builder.setFollowRedirects(followRedirects);
            this.populateHeaders(request, builder);
            request.getQueryParams().entryList().forEach(entry -> builder.addQueryParam((String)entry.getKey(), (String)entry.getValue()));
            if (authentication != null) {
                Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
                if (authentication.getType() == HttpAuthenticationType.BASIC) {
                    realmBuilder.setScheme(Realm.AuthScheme.BASIC);
                } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                    realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
                } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                    String workstation;
                    String domain = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getDomain();
                    if (domain != null) {
                        realmBuilder.setNtlmDomain(domain);
                    }
                    String ntlmHost = (workstation = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getWorkstation()) != null ? workstation : this.getHostName();
                    realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
                }
                builder.setRealm(realmBuilder.build());
            }
            if (request.getEntity() != null) {
                if (request.getEntity().isStreaming()) {
                    builder.setBody((BodyGenerator)new InputStreamBodyGenerator(request.getEntity().getContent()));
                } else if (request.getEntity().isComposed()) {
                    for (HttpPart part : request.getEntity().getParts()) {
                        if (part.getFileName() != null) {
                            builder.addBodyPart((Part)new ByteArrayPart(part.getName(), IOUtils.toByteArray(part.getInputStream()), part.getContentType(), null, part.getFileName()));
                            continue;
                        }
                        byte[] content = IOUtils.toByteArray(part.getInputStream());
                        builder.addBodyPart((Part)new ByteArrayPart(part.getName(), content, part.getContentType(), null));
                    }
                } else {
                    builder.setBody(request.getEntity().getBytes());
                }
            }
            builder.setRequestTimeout(responseTimeout);
        });
        reqBuilder.setUrl(request.getUri());
        return reqBuilder.build();
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, RequestConfigurer requestConfigurer) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestConfigurer.configure(requestBuilder);
        return requestBuilder;
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        boolean hasNoContentLength;
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        boolean hasNoTransferEncoding = request.getHeaderValueIgnoreCase("Transfer-Encoding") == null;
        boolean bl = hasNoContentLength = request.getHeaderValueIgnoreCase("Content-Length") == null;
        if (hasNoTransferEncoding && hasNoContentLength && request.getEntity().getLength().isPresent()) {
            builder.addHeader("Content-Length", String.valueOf(request.getEntity().getLength().get()));
        }
        if (!this.usePersistentConnections) {
            String connectionHeaderValue = request.getHeaderValueIgnoreCase("Connection");
            if (connectionHeaderValue != null && !"close".equals(connectionHeaderValue) && logger.isDebugEnabled()) {
                logger.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)connectionHeaderValue);
            }
            builder.setHeader("Connection", "close");
        }
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Override
    public void stop() {
        this.asyncHttpClient.close();
        this.workerScheduler.stop();
        this.selectorScheduler.stop();
    }

    private class ResponseBodyDeferringAsyncHandler
    implements AsyncHandler<Response> {
        private volatile Response response;
        private final OutputStream output;
        private final InputStream input;
        private final CompletableFuture<HttpResponse> future;
        private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
        private final AtomicBoolean handled = new AtomicBoolean(false);

        public ResponseBodyDeferringAsyncHandler(CompletableFuture<HttpResponse> future, PipedOutputStream output) throws IOException {
            this.output = output;
            this.future = future;
            this.input = new PipedInputStream(output, GrizzlyHttpClient.this.responseBufferSize);
        }

        public void onThrowable(Throwable t) {
            try {
                this.closeOut();
            }
            catch (IOException e) {
                logger.warn("Error closing HTTP response stream: ", (Throwable)e);
            }
            if (!this.handled.getAndSet(true)) {
                Exception exception = t instanceof TimeoutException ? (TimeoutException)t : (t instanceof IOException ? (IOException)t : new IOException(t));
                this.future.completeExceptionally(exception);
            } else {
                logger.warn("Error handling HTTP response stream: ", t);
            }
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            this.responseBuilder.reset();
            this.responseBuilder.accumulate(responseStatus);
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            this.responseBuilder.accumulate(headers);
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            this.handleIfNecessary();
            bodyPart.writeTo(this.output);
            return AsyncHandler.STATE.CONTINUE;
        }

        protected void closeOut() throws IOException {
            try {
                this.output.flush();
            }
            finally {
                this.output.close();
            }
        }

        public Response onCompleted() throws IOException {
            this.handleIfNecessary();
            this.closeOut();
            return null;
        }

        private void handleIfNecessary() {
            if (!this.handled.getAndSet(true)) {
                this.response = this.responseBuilder.build();
                try {
                    this.future.complete(GrizzlyHttpClient.this.createMuleResponse(this.response, this.input));
                }
                catch (IOException e) {
                    this.future.completeExceptionally(e);
                }
            }
        }
    }

    private class ResponseAsyncHandler
    extends AsyncCompletionHandler<Response> {
        private final CompletableFuture<HttpResponse> future;

        public ResponseAsyncHandler(CompletableFuture<HttpResponse> future) {
            this.future = future;
        }

        public Response onCompleted(Response response) throws Exception {
            this.future.complete(GrizzlyHttpClient.this.createMuleResponse(response, response.getResponseBodyAsStream()));
            return null;
        }

        public void onThrowable(Throwable t) {
            logger.warn("Error handling HTTP response.", t);
            Exception exception = t instanceof TimeoutException ? (TimeoutException)t : (t instanceof IOException ? (IOException)t : new IOException(t));
            this.future.completeExceptionally(exception);
        }
    }

    @FunctionalInterface
    protected static interface RequestConfigurer {
        public void configure(RequestBuilder var1) throws IOException;
    }
}

