/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.service.scheduler.internal.AbstractRunnableFutureDecorator;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunnableRepeatableFutureDecorator<V>
extends AbstractRunnableFutureDecorator<V> {
    private static final Logger logger = LoggerFactory.getLogger(RunnableRepeatableFutureDecorator.class);
    private final Supplier<RunnableFuture<V>> taskSupplier;
    private final Consumer<RunnableRepeatableFutureDecorator<V>> wrapUpCallback;
    private final ClassLoader classLoader;
    private final DefaultScheduler scheduler;
    private final String taskAsString;
    private volatile boolean running = false;
    private volatile boolean cancelled = false;
    private RunnableFuture<V> task;

    RunnableRepeatableFutureDecorator(Supplier<RunnableFuture<V>> taskSupplier, Consumer<RunnableRepeatableFutureDecorator<V>> wrapUpCallback, ClassLoader classLoader, DefaultScheduler scheduler, String taskAsString, Integer id) {
        super(id);
        this.taskSupplier = taskSupplier;
        this.wrapUpCallback = wrapUpCallback;
        this.classLoader = classLoader;
        this.scheduler = scheduler;
        this.taskAsString = taskAsString;
    }

    @Override
    public void run() {
        if (this.running) {
            if (logger.isTraceEnabled()) {
                logger.trace(this.toString() + " still running, returning.");
            }
            return;
        }
        if (this.cancelled) {
            logger.debug("Task " + this.toString() + " has been cancelled. Retunrning immendiately.");
            return;
        }
        this.task = this.taskSupplier.get();
        this.doRun(this.task, this.classLoader);
    }

    @Override
    protected long beforeRun() {
        this.running = true;
        return super.beforeRun();
    }

    @Override
    protected void wrapUp() throws Exception {
        this.running = false;
        try {
            this.wrapUpCallback.accept(this);
        }
        finally {
            super.wrapUp();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        boolean success = true;
        if (this.task != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cancelling task " + this.toString() + " (mayInterruptIfRunning=" + mayInterruptIfRunning + ")...");
            }
            success = this.task.cancel(mayInterruptIfRunning);
        }
        this.scheduler.taskFinished(this);
        return success;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        if (this.task != null) {
            return this.task.isDone();
        }
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.task != null) {
            return this.task.get();
        }
        return null;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.task != null) {
            return this.task.get(timeout, unit);
        }
        return null;
    }

    public String toString() {
        return this.getSchedulerName() + " - " + this.taskAsString + "(repeatable)";
    }

    @Override
    public String getSchedulerName() {
        return this.scheduler.getName();
    }
}

