/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.DispatchingException;
import org.mule.runtime.soap.api.exception.SoapFaultException;
import org.mule.runtime.soap.api.exception.SoapServiceException;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.generator.SoapRequestGenerator;
import org.mule.service.soap.generator.SoapResponseGenerator;
import org.mule.service.soap.generator.attachment.AttachmentRequestEnricher;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.MtomRequestEnricher;
import org.mule.service.soap.generator.attachment.MtomResponseEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentRequestEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.metadata.DefaultSoapMetadataResolver;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SoapCxfClient
implements SoapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapCxfClient.class);
    public static final String MESSAGE_DISPATCHER = "mule.soap.dispatcher";
    public static final String MULE_ATTACHMENTS_KEY = "mule.soap.attachments";
    public static final String MULE_WSC_ADDRESS = "mule.soap.address";
    public static final String MULE_HEADERS_KEY = "mule.soap.headers";
    public static final String MULE_TRANSPORT_HEADERS_KEY = "mule.soap.transport.headers";
    public static final String MULE_SOAP_ACTION = "mule.soap.action";
    public static final String MULE_SOAP_OPERATION_STYLE = "mule.soap.operation.type";
    private final SoapRequestGenerator requestGenerator;
    private final SoapResponseGenerator responseGenerator;
    private final Client client;
    private final ServiceDefinition definition;
    private final XmlTypeLoader loader;
    private final String address;
    private final MessageDispatcher dispatcher;
    private final SoapVersion version;
    private final String encoding;
    private final boolean isMtom;

    SoapCxfClient(Client client, ServiceDefinition definition, XmlTypeLoader typeLoader, String address, MessageDispatcher dispatcher, SoapVersion version, String encoding, boolean isMtom) {
        this.client = client;
        this.definition = definition;
        this.loader = typeLoader;
        this.address = address;
        this.dispatcher = dispatcher;
        this.version = version;
        this.isMtom = isMtom;
        this.encoding = encoding;
        this.requestGenerator = new SoapRequestGenerator(this.getRequestEnricher(isMtom), definition, this.loader);
        this.responseGenerator = new SoapResponseGenerator(this.getResponseEnricher(isMtom));
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded(this.dispatcher, LOGGER);
        this.client.destroy();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded(this.dispatcher);
    }

    @Override
    public SoapResponse consume(SoapRequest request) throws SoapFaultException {
        String operation = request.getOperation();
        ExchangeImpl exchange = new ExchangeImpl();
        Object[] response = this.invoke(request, (Exchange)exchange);
        return this.responseGenerator.generate(operation, response, (Exchange)exchange);
    }

    @Override
    public SoapMetadataResolver getMetadataResolver() {
        return new DefaultSoapMetadataResolver(this.definition, this.loader);
    }

    private Object[] invoke(SoapRequest request, Exchange exchange) {
        String operation = request.getOperation();
        XMLStreamReader xmlBody = this.getXmlBody(request);
        try {
            Map<String, Object> ctx = this.getInvocationContext(request);
            return this.client.invoke(this.getInvocationOperation(), new Object[]{xmlBody}, ctx, exchange);
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf.getFaultCode(), sf.getSubCode(), this.parseExceptionDetail(sf.getDetail()).orElse(null), sf.getReason(), sf.getNode(), sf.getRole(), sf);
        }
        catch (Fault f) {
            if (f.getMessage().contains("COULD_NOT_READ_XML")) {
                throw new BadRequestException("Error consuming the operation [" + operation + "], the request body is not a valid XML");
            }
            throw new SoapFaultException(f.getFaultCode(), this.parseExceptionDetail(f.getDetail()).orElse(null), f);
        }
        catch (DispatchingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SoapServiceException("Unexpected error while consuming the web service operation [" + operation + "]", e);
        }
    }

    private XMLStreamReader getXmlBody(SoapRequest request) {
        try {
            String xml = request.getContent() != null ? org.apache.commons.io.IOUtils.toString((InputStream)request.getContent()) : null;
            return this.requestGenerator.generate(request.getOperation(), xml, request.getAttachments());
        }
        catch (IOException e) {
            throw new BadRequestException("an error occurred while parsing the provided request");
        }
    }

    private BindingOperationInfo getInvocationOperation() throws Exception {
        Endpoint ep = this.client.getEndpoint();
        QName q = new QName(ep.getService().getName().getNamespaceURI(), "invoke");
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    private Map<String, Object> getInvocationContext(SoapRequest request) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(MULE_ATTACHMENTS_KEY, this.isMtom ? this.transformToCxfAttachments(request.getAttachments()) : Collections.emptyMap());
        props.put(MULE_WSC_ADDRESS, this.address);
        props.put(Message.ENCODING, this.encoding == null ? "UTF-8" : this.encoding);
        props.put(MULE_HEADERS_KEY, this.transformToCxfHeaders(request.getSoapHeaders()));
        props.put(MULE_TRANSPORT_HEADERS_KEY, request.getTransportHeaders());
        props.put(MESSAGE_DISPATCHER, this.dispatcher);
        props.put(MULE_SOAP_OPERATION_STYLE, this.definition.getOperation(request.getOperation()).getType());
        if (this.version == SoapVersion.SOAP12) {
            props.put(MULE_SOAP_ACTION, request.getOperation());
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("RequestContext", props);
        return ctx;
    }

    private List<SoapHeader> transformToCxfHeaders(Map<String, String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().map(header -> {
            try {
                return new SoapHeader(new QName(null, (String)header.getKey()), (Object)XmlTransformationUtils.stringToDomElement((String)header.getValue()));
            }
            catch (Exception e) {
                throw new BadRequestException("Cannot parse input header [" + (String)header.getKey() + "]", (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private Map<String, Attachment> transformToCxfAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            try {
                builder.put(name, (Object)new AttachmentImpl(name, IOUtils.toDataHandler(name, value.getContent(), value.getContentType())));
            }
            catch (IOException e) {
                throw new BadRequestException(String.format("Error while preparing attachment [%s] for upload", name), (Throwable)e);
            }
        });
        return builder.build();
    }

    private AttachmentRequestEnricher getRequestEnricher(boolean isMtom) {
        return isMtom ? new MtomRequestEnricher(this.definition, this.loader) : new SoapAttachmentRequestEnricher(this.definition, this.loader);
    }

    private AttachmentResponseEnricher getResponseEnricher(boolean isMtom) {
        return isMtom ? new MtomResponseEnricher(this.definition, this.loader) : new SoapAttachmentResponseEnricher(this.definition, this.loader);
    }

    private Optional<String> parseExceptionDetail(Element detail) {
        try {
            return Optional.ofNullable(XmlTransformationUtils.nodeToString(detail));
        }
        catch (XmlTransformationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while parsing Soap Exception detail: " + detail.toString(), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

