/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.tools.api.packager.structure.FolderNames;

public class MuleArtifactContentResolver {
    private final Path projectBaseFolder;
    private List<String> configs;
    private List<String> exportedPackages;
    private List<String> exportedResources;

    public MuleArtifactContentResolver(Path projectBaseFolder) {
        Preconditions.checkArgument((projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
        this.projectBaseFolder = projectBaseFolder;
    }

    public List<String> getExportedPackages() throws IOException {
        if (this.exportedPackages == null) {
            this.exportedPackages = this.getResources(this.resolveExportedPackagesPath());
        }
        return this.exportedPackages;
    }

    public List<String> getExportedResources() throws IOException {
        if (this.exportedResources == null) {
            this.exportedResources = this.getResources(this.resolveExportedResourcesPath());
        }
        return this.exportedResources;
    }

    public List<String> getConfigs() throws IOException {
        if (this.configs == null) {
            this.configs = this.getResources(this.resolveConfigsPath());
        }
        return this.configs;
    }

    private List<String> getResources(Path path) throws IOException {
        File resourcesFolder = path.toFile();
        if (resourcesFolder == null) {
            throw new IOException("The resources folder is invalid");
        }
        if (!resourcesFolder.exists()) {
            return Collections.emptyList();
        }
        Collection resourcesFolderContent = FileUtils.listFiles((File)path.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        return resourcesFolderContent.stream().map(File::toPath).map(p -> resourcesFolder.toPath().relativize((Path)p)).map(Path::toString).collect(Collectors.toList());
    }

    public Path resolveExportedPackagesPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.JAVA.value());
    }

    public Path resolveExportedResourcesPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.RESOURCES.value());
    }

    public Path resolveConfigsPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.MULE.value());
    }
}

