/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.AetherMavenClientProvider;
import org.mule.maven.client.internal.DefaultLocalRepositorySupplierFactory;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;

public class MuleMavenPluginClientProvider {
    private final Log log;
    private List<RemoteRepository> remoteRepositories;

    public MuleMavenPluginClientProvider(List<RemoteRepository> remoteRepositories, Log log) {
        Preconditions.checkArgument((remoteRepositories != null ? 1 : 0) != 0, (Object)"Remote repositories list can not be null");
        this.remoteRepositories = remoteRepositories;
        this.log = log;
    }

    public AetherMavenClient buildMavenClient() {
        MavenConfiguration mavenConfiguration = this.buildMavenConfiguration();
        AetherMavenClientProvider provider = new AetherMavenClientProvider();
        return (AetherMavenClient)provider.createMavenClient(mavenConfiguration);
    }

    public MavenConfiguration buildMavenConfiguration() {
        Supplier<File> localMavenRepository;
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = new MavenConfiguration.MavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        Optional<File> globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional<File> userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        globalSettings.ifPresent(mavenConfigurationBuilder::globalSettingsLocation);
        userSettings.ifPresent(mavenConfigurationBuilder::userSettingsLocation);
        DefaultLocalRepositorySupplierFactory localRepositorySupplierFactory = new DefaultLocalRepositorySupplierFactory();
        try {
            localMavenRepository = localRepositorySupplierFactory.environmentMavenRepositorySupplier();
        }
        catch (IllegalArgumentException e) {
            localMavenRepository = () -> new File(System.getenv("WORKSPACE"), ".repository");
        }
        this.remoteRepositories.stream().filter(this::hasValidURL).map(this::toRemoteRepo).forEach(mavenConfigurationBuilder::remoteRepository);
        return mavenConfigurationBuilder.localMavenRepositoryLocation(localMavenRepository.get()).build();
    }

    private boolean hasValidURL(RemoteRepository remoteRepository) {
        try {
            new URL(remoteRepository.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private org.mule.maven.client.api.model.RemoteRepository toRemoteRepo(RemoteRepository remoteRepository) {
        String id = remoteRepository.getId();
        Optional<Authentication> authentication = this.getAuthentication(remoteRepository);
        URL remoteRepositoryUrl = this.getURL(remoteRepository);
        RemoteRepository.RemoteRepositoryBuilder builder = new RemoteRepository.RemoteRepositoryBuilder();
        authentication.ifPresent(builder::authentication);
        return builder.id(id).url(remoteRepositoryUrl).build();
    }

    private URL getURL(RemoteRepository remoteRepository) {
        try {
            return new URL(remoteRepository.getUrl());
        }
        catch (MalformedURLException e) {
            this.log.info((CharSequence)("Could not resolve remote repository URL: " + remoteRepository));
            return null;
        }
    }

    private Optional<Authentication> getAuthentication(RemoteRepository remoteRepository) {
        AuthenticationContext authenticationContext = AuthenticationContext.forRepository((RepositorySystemSession)new DefaultRepositorySystemSession(), (RemoteRepository)remoteRepository);
        if (authenticationContext == null) {
            return Optional.empty();
        }
        String password = new String((char[])authenticationContext.get("password", char[].class));
        String username = new String((char[])authenticationContext.get("username", char[].class));
        Authentication.AuthenticationBuilder authenticationBuilder = new Authentication.AuthenticationBuilder();
        AuthenticationContext.close((AuthenticationContext)authenticationContext);
        return Optional.of(authenticationBuilder.password(password).username(username).build());
    }
}

