/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.MulePluginResolver;
import org.mule.tools.api.validation.MulePluginsCompatibilityValidator;

public abstract class AbstractProjectValidator {
    protected final Path projectBaseDir;
    protected final String packagingType;
    protected final Project dependencyProject;
    private final MulePluginResolver resolver;
    protected final MulePluginsCompatibilityValidator mulePluginsCompatibilityValidator = new MulePluginsCompatibilityValidator();

    public AbstractProjectValidator(Path projectBaseDir, String packagingType, Project dependencyProject, MulePluginResolver resolver) {
        this.projectBaseDir = projectBaseDir;
        this.packagingType = packagingType;
        this.dependencyProject = dependencyProject;
        this.resolver = resolver;
    }

    public Boolean isProjectValid() throws ValidationException {
        Preconditions.checkState((this.packagingType != null ? 1 : 0) != 0, (Object)"Packaging type should not be null");
        AbstractProjectValidator.isPackagingTypeValid(this.packagingType);
        this.mulePluginsCompatibilityValidator.validate(this.resolver.resolveMulePlugins(this.dependencyProject));
        this.additionalValidation();
        return true;
    }

    protected abstract void additionalValidation() throws ValidationException;

    public static Boolean isPackagingTypeValid(String packagingType) throws ValidationException {
        try {
            PackagingType.fromString(packagingType);
        }
        catch (IllegalArgumentException e) {
            List packagingTypeNames = Arrays.stream(PackagingType.values()).map(type -> type.toString()).collect(Collectors.toList());
            throw new ValidationException(packagingType == null ? e.getMessage() : "Unknown packaging type " + packagingType + ". Please specify a valid mule packaging type: " + String.join((CharSequence)", ", packagingTypeNames));
        }
        return true;
    }
}

