/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.exception.ValidationException;

public class MuleArtifactJsonValidator {
    public static void validate(Path projectBaseDir) throws ValidationException {
        MuleArtifactJsonValidator.isMuleArtifactJsonPresent(projectBaseDir);
        MuleArtifactJsonValidator.isMuleArtifactJsonValid(projectBaseDir);
    }

    public static void isMuleArtifactJsonPresent(Path projectBaseDir) throws ValidationException {
        String errorMessage = "Invalid Mule project. Missing %s file, it must be present in the root of application";
        if (!projectBaseDir.resolve("mule-artifact.json").toFile().exists()) {
            throw new ValidationException(String.format(errorMessage, "mule-artifact.json"));
        }
    }

    public static void isMuleArtifactJsonValid(Path projectBaseDir) throws ValidationException {
        MuleApplicationModel muleArtifact;
        File muleArtifactJsonFile = projectBaseDir.resolve("mule-artifact.json").toFile();
        try {
            muleArtifact = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleArtifactJsonFile, (String)null));
            if (muleArtifact == null) {
                throw new ValidationException("The mule-artifact.json file is empty");
            }
        }
        catch (JsonSyntaxException | IOException e) {
            throw new ValidationException(e);
        }
        MuleArtifactJsonValidator.validateMuleArtifactMandatoryFields(muleArtifact);
    }

    protected static void validateMuleArtifactMandatoryFields(MuleApplicationModel muleArtifact) throws ValidationException {
        ArrayList<String> missingFields = new ArrayList<String>();
        MuleArtifactJsonValidator.checkName(muleArtifact, missingFields);
        MuleArtifactJsonValidator.checkMinMuleVersionValue(muleArtifact, missingFields);
        MuleArtifactJsonValidator.checkClassLoaderModelDescriptor(muleArtifact, missingFields);
        if (!missingFields.isEmpty()) {
            throw new ValidationException("The following mandatory fields in the mule-artifact.json are missing: " + missingFields);
        }
    }

    protected static void checkName(MuleApplicationModel muleArtifact, List<String> missingFields) {
        String nameValue = muleArtifact.getName();
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            missingFields.add("name");
        }
    }

    protected static void checkMinMuleVersionValue(MuleApplicationModel muleArtifact, List<String> missingFields) {
        String minMuleVersionValue = muleArtifact.getMinMuleVersion();
        if (StringUtils.isBlank((CharSequence)minMuleVersionValue)) {
            missingFields.add("minMuleVersion");
        }
    }

    protected static void checkClassLoaderModelDescriptor(MuleApplicationModel muleArtifact, List<String> missingFields) {
        MuleArtifactLoaderDescriptor classLoaderModelDescriptor = muleArtifact.getClassLoaderModelLoaderDescriptor();
        if (classLoaderModelDescriptor == null) {
            missingFields.add("classLoaderModelLoaderDescriptor");
        }
        if (classLoaderModelDescriptor == null || StringUtils.isBlank((CharSequence)classLoaderModelDescriptor.getId())) {
            missingFields.add("classLoaderModelLoaderDescriptor.id");
        }
    }
}

