/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.core.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001M\u0011\u0001#\u00138eKb,GmQ*W!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011A\u00029beN,'O\u0003\u0002\u0006\r\u00051!/Z1eKJT!a\u0002\u0005\u0002\u0007\r\u001chO\u0003\u0002\n\u0015\u00051Qn\u001c3vY\u0016T!a\u0003\u0007\u0002\u0005Y\u0014$BA\u0007\u000f\u0003\u00159X-\u0019<f\u0015\ty\u0001#\u0001\u0003nk2,'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u00195K\u0016)beN,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u00035\u0019wN\u001c;f]R\u0014V-\u00193feV\t1\u0004\u0005\u0002\u001d=5\tQD\u0003\u0002\u0006\u0011%\u0011q$\b\u0002\r'>,(oY3SK\u0006$WM\u001d\u0005\tC\u0001\u0011\t\u0011)A\u00057\u0005q1m\u001c8uK:$(+Z1eKJ\u0004\u0003\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013(\u0003-\u00197KV*fiRLgnZ:\u0011\u0005U)\u0013B\u0001\u0014\u0003\u0005-\u00195KV*fiRLgnZ:\n\u0005\r2\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b1\u0002\u0016\u0002\u0007\r$\b\u0010\u0005\u0002,]5\tAF\u0003\u0002.\u0015\u0005)Qn\u001c3fY&\u0011q\u0006\f\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\b\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00024m]\"\"\u0001N\u001b\u0011\u0005U\u0001\u0001\"B\u00151\u0001\bQ\u0003\"B\r1\u0001\u0004Y\u0002\"B\u00121\u0001\u0004!\u0003bB\u001d\u0001\u0005\u0004%\tAO\u0001\re\u0016\u001cwN\u001d3U_.,gn]\u000b\u0002wA\u0011A\u0004P\u0005\u0003{u\u0011\u0001\u0003R3gCVdG\u000fT8oO\u0006\u0013(/Y=\t\r}\u0002\u0001\u0015!\u0003<\u00035\u0011XmY8sIR{7.\u001a8tA!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0015AC2tm\u0016sGO]5fgV\t1\t\u0005\u0002E\u00116\tQI\u0003\u0002\u0006\r*\u0011q\tC\u0001\u0004q6d\u0017BA%F\u0005)!vn[3o\u0003J\u0014\u0018-\u001f\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\"\u0002\u0017\r\u001ch/\u00128ue&,7\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0001O\u0003!awnY1uS>tW#A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\t1{gn\u001a\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u00031awnY1uS>tw\fJ3r)\tA6\f\u0005\u0002Q3&\u0011!,\u0015\u0002\u0005+:LG\u000fC\u0004]+\u0006\u0005\t\u0019A(\u0002\u0007a$\u0013\u0007\u0003\u0004_\u0001\u0001\u0006KaT\u0001\nY>\u001c\u0017\r^5p]\u0002BQ\u0001\u0019\u0001\u0005\u0002\u0005\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0003E\u0016\u0004\"\u0001U2\n\u0005\u0011\f&a\u0002\"p_2,\u0017M\u001c\u0005\u0006M~\u0003\raZ\u0001\u0006S:$W\r\u001f\t\u0003!\"L!![)\u0003\u0007%sG\u000fC\u0003l\u0001\u0011\u0005A.A\u0002hKR$\"!\u001c9\u0011\u0005Uq\u0017BA8\u0003\u0005%\u00195K\u0016*fG>\u0014H\rC\u0003gU\u0002\u0007q\rC\u0003s\u0001\u0011\u00051/\u0001\u0005tW&\u0004H*\u001b8f)\u0005A\u0006\"B;\u0001\t\u00131\u0018!C3mK6,g\u000e^!u)\r9\u00181\u0003\t\u0004!bT\u0018BA=R\u0005\u0019y\u0005\u000f^5p]B)10a\u0002\u0002\u000e9\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\ty(#\u0001\u0004=e>|GOP\u0005\u0002%&\u0019\u0011QA)\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000b\t\u0006cA\u000b\u0002\u0010%\u0019\u0011\u0011\u0003\u0002\u0003\u001f%sG-\u001a=fI\u000e\u001bf+\u00128uefDQA\u001a;A\u0002\u001dDq!a\u0006\u0001\t\u0013\tI\"A\u0003qCJ\u001cX\rF\u0001{\u0001")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader contentReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;

    public SourceReader contentReader() {
        return this.contentReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean contains(int index) {
        return this.recordTokens().size() > (long)index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(int index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException(UnknownLocation$.MODULE$, index, this.recordTokens().size());
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.contentReader()));
    }

    @Override
    public void skipLine() {
        this.contentReader().seek(this.location());
        char next = this.contentReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.contentReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.contentReader().readAscii();
                next = this.contentReader().lookAheadAscii();
                this.location_$eq(this.contentReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(int index) {
        None$ none$;
        long size;
        if (this.headers().isEmpty()) {
            boolean hasHeaderLine;
            int headerLine = super.cSVSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.cSVSettings().header()) {
                this.processHeaders(this.parse());
            }
            this.skipLines(this.linesToSkipBeforeBody());
        }
        if ((size = this.recordTokens().size()) <= (long)index) {
            for (long remaining = (long)index - size; remaining >= 0L; --remaining) {
                Seq<IndexedCSVEntry> nextRecord = this.parse();
                if (!nextRecord.nonEmpty()) continue;
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some(nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply(index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.contentReader(), this.escape());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<IndexedCSVEntry> parse() {
        void var2_1;
        ArrayBuffer indexedEntries;
        do {
            BoxedUnit boxedUnit;
            this.contentReader().seek(this.location());
            indexedEntries = new ArrayBuffer();
            boolean insideQuotations = false;
            boolean recordEnded = false;
            long valueIndex = this.contentReader().position();
            long size = -1L;
            char value = this.contentReader().readAscii();
            if (value != '\uffff') {
                while (!recordEnded && value != '\uffff') {
                    Object object;
                    char next = value;
                    if (insideQuotations) {
                        if (this.isEscapeChar(next) && this.isQuoteChar(this.contentReader().lookAheadAscii())) {
                            object = BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii());
                        } else {
                            if (this.isQuoteChar(next)) {
                                insideQuotations = false;
                                size = this.contentReader().previousPosition() - valueIndex;
                            }
                            object = BoxedUnit.UNIT;
                        }
                    } else if (this.isEscapeChar(next) && this.requiredEscape(this.contentReader().lookAheadAscii())) {
                        object = BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii());
                    } else {
                        if (this.isQuoteChar(next)) {
                            insideQuotations = true;
                            valueIndex = this.contentReader().position();
                        } else if (this.isEntrySeparator(next)) {
                            size = size == -1L ? this.contentReader().previousPosition() - valueIndex : size;
                            long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                            indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                            valueIndex = this.contentReader().position();
                            size = -1L;
                        } else if (this.isLineEnding(next)) {
                            size = size == -1L ? this.contentReader().previousPosition() - valueIndex : size;
                            long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                            indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                            Object object2 = next == '\r' && this.contentReader().lookAheadAscii() == '\n' ? BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii()) : BoxedUnit.UNIT;
                            recordEnded = true;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    if (recordEnded) continue;
                    value = this.contentReader().readAscii();
                }
                if (!recordEnded) {
                    size = size == -1L ? this.contentReader().position() - valueIndex : size;
                    long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                    boxedUnit = indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.location_$eq(this.contentReader().position());
        } while (super.cSVSettings().ignoreEmptyLine() && indexedEntries.size() == 1 && ((IndexedCSVEntry)indexedEntries.apply(0)).length() == 0L);
        return var2_1;
    }

    public IndexedCSVParser(SourceReader contentReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.contentReader = contentReader;
        super(cSVSettings);
        ctx.registerCloseable(contentReader);
        this.recordTokens = ctx.registerCloseable(new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1()));
        this.csvEntries = ctx.registerCloseable(new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1()));
        this.location = 0L;
    }
}

