/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import com.google.common.base.Throwables;
import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.spring.internal.LazyComponentInitializer;
import org.mule.runtime.config.spring.internal.dsl.model.NoSuchComponentModelException;

public class LazyConnectivityTestingService
implements ConnectivityTestingService,
Initialisable {
    public static final String NON_LAZY_CONNECTIVITY_TESTING_SERVICE = "_muleNonLazyConnectivityTestingService";
    private final LazyComponentInitializer lazyComponentInitializer;
    private final Supplier<ConnectivityTestingService> connectivityTestingServiceSupplier;
    private ConnectivityTestingService connectivityTestingService;

    public LazyConnectivityTestingService(LazyComponentInitializer lazyComponentInitializer, Supplier<ConnectivityTestingService> connectivityTestingServiceSupplier) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.connectivityTestingServiceSupplier = connectivityTestingServiceSupplier;
    }

    @Override
    public ConnectionValidationResult testConnection(Location location) {
        try {
            this.lazyComponentInitializer.initializeComponent(location);
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof NoSuchComponentModelException) {
                throw new ObjectNotFoundException(location.toString());
            }
            List causalChain = Throwables.getCausalChain((Throwable)e);
            return causalChain.stream().filter(exception -> exception.getClass().equals(ConnectionException.class) && ((ConnectionException)exception).getErrorType().isPresent()).map(exception -> ConnectionValidationResult.failure(exception.getMessage(), ((ConnectionException)exception).getErrorType().get(), (Exception)exception)).findFirst().orElse(this.unknownFailureResponse(this.lastMessage(causalChain), e));
        }
        catch (Exception e) {
            return this.unknownFailureResponse(e.getCause().getMessage(), e);
        }
        return this.connectivityTestingService.testConnection(location);
    }

    private ConnectionValidationResult unknownFailureResponse(String message, Exception e) {
        return ConnectionValidationResult.failure(message, e);
    }

    private String lastMessage(List<Throwable> causalChain) {
        return causalChain.get(causalChain.size() - 1).getMessage();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.connectivityTestingService = this.connectivityTestingServiceSupplier.get();
    }
}

