/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.spring.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;

class ReferenceBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String REF_ATTRIBUTE = "ref";
    private ImmutableMap<ComponentIdentifier, Consumer<CreateBeanDefinitionRequest>> referenceConsumers = new ImmutableMap.Builder().put((Object)ApplicationModel.TRANSFORMER_IDENTIFIER, this.getConsumer()).build();

    ReferenceBeanDefinitionCreator() {
    }

    private Consumer<CreateBeanDefinitionRequest> getConsumer() {
        return beanDefinitionRequest -> {
            SpringComponentModel componentModel = beanDefinitionRequest.getComponentModel();
            componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(componentModel.getParameters().get(REF_ATTRIBUTE)));
            ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
            beanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit(objectTypeVisitor);
            componentModel.setType(objectTypeVisitor.getType());
        };
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (this.referenceConsumers.containsKey((Object)componentModel.getIdentifier())) {
            ((Consumer)this.referenceConsumers.get((Object)componentModel.getIdentifier())).accept(createBeanDefinitionRequest);
            return true;
        }
        return false;
    }
}

