/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.connector.ReplyToHandler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.internal.message.DefaultEventBuilder;

public interface InternalEvent
extends Serializable,
Event {
    public InternalEventContext getContext();

    public SecurityContext getSecurityContext();

    public Map<String, ?> getInternalParameters();

    public Optional<GroupCorrelation> getGroupCorrelation();

    public String getCorrelationId();

    @Deprecated
    public byte[] getMessageAsBytes(MuleContext var1) throws MuleException;

    @Deprecated
    public Object transformMessage(DataType var1, MuleContext var2) throws MessageTransformerException;

    @Deprecated
    public String transformMessageToString(MuleContext var1) throws MessageTransformerException;

    @Deprecated
    public String getMessageAsString(MuleContext var1) throws MuleException;

    @Deprecated
    public String getMessageAsString(Charset var1, MuleContext var2) throws MuleException;

    @Deprecated
    public MuleSession getSession();

    @Deprecated
    public FlowConstruct getFlowConstruct();

    @Deprecated
    public MuleContext getMuleContext();

    @Deprecated
    public ReplyToHandler getReplyToHandler();

    @Deprecated
    public Object getReplyToDestination();

    public boolean isNotificationsEnabled();

    public FlowCallStack getFlowCallStack();

    @Deprecated
    public String getLegacyCorrelationId();

    public static Builder builder(InternalEventContext context) {
        return new DefaultEventBuilder(context);
    }

    public static Builder builder(InternalEvent event) {
        return new DefaultEventBuilder(event);
    }

    public static Builder builder(InternalEventContext context, InternalEvent event) {
        return new DefaultEventBuilder(context, event);
    }

    public static <T> T getVariableValueOrNull(String key, InternalEvent event) {
        if (event.getVariables().containsKey(key)) {
            return (T)event.getVariables().get(key).getValue();
        }
        return null;
    }

    public static InternalEvent getCurrentEvent() {
        return (InternalEvent)CurrentEventHolder.currentEvent.get();
    }

    public static void setCurrentEvent(InternalEvent event) {
        CurrentEventHolder.currentEvent.set(event);
    }

    public static interface Builder {
        public Builder message(Message var1);

        public Builder variables(Map<String, ?> var1);

        public Builder addVariable(String var1, Object var2);

        public Builder addVariable(String var1, Object var2, DataType var3);

        public Builder removeVariable(String var1);

        public Builder properties(Map<String, ?> var1);

        public Builder parameters(Map<String, ?> var1);

        public Builder addParameter(String var1, Object var2);

        public Builder addParameter(String var1, Object var2, DataType var3);

        public Builder removeParameter(String var1);

        public Builder internalParameters(Map<String, ?> var1);

        public Builder addInternalParameter(String var1, Object var2);

        public Builder removeInternalParameter(String var1);

        @Deprecated
        public Builder correlationId(String var1);

        public Builder groupCorrelation(Optional<GroupCorrelation> var1);

        public Builder error(Error var1);

        @Deprecated
        public Builder replyToHandler(ReplyToHandler var1);

        @Deprecated
        public Builder replyToDestination(Object var1);

        @Deprecated
        public Builder flow(FlowConstruct var1);

        @Deprecated
        public Builder disableNotifications();

        @Deprecated
        public Builder session(MuleSession var1);

        public InternalEvent build();
    }

    public static class CurrentEventHolder {
        private static final ThreadLocal<InternalEvent> currentEvent = new ThreadLocal();
    }
}

