/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyChain
extends AbstractAnnotatedObject
implements Initialisable,
Startable,
Stoppable,
Disposable,
Processor {
    @Inject
    private MuleContext muleContext;
    private List<Processor> processors;
    private MessageProcessorChain processorChain;

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.processorChain = new DefaultMessageProcessorChainBuilder().chain(this.processors).build();
        this.processorChain.setMuleContext(this.muleContext);
        this.processorChain.initialise();
    }

    @Override
    public void start() throws MuleException {
        this.processorChain.start();
    }

    @Override
    public void dispose() {
        this.processorChain.dispose();
    }

    @Override
    public void stop() throws MuleException {
        this.processorChain.stop();
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return this.processorChain.process(event);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Mono.from(publisher).transform((Function)this.processorChain);
    }
}

