/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class NetworkUtils {
    private static final Map<String, String> ipPerHost = new ConcurrentHashMap<String, String>();
    private static InetAddress localHost;

    private NetworkUtils() {
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            localHost = InetAddress.getLocalHost();
        }
        return localHost;
    }

    public static String getLocalHostIp(String host) throws UnknownHostException {
        String ip = ipPerHost.get(host);
        if (ip == null) {
            ip = InetAddress.getByName(host).getHostAddress();
            ipPerHost.put(host, ip);
        }
        return ip;
    }
}

