/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.el.context.DataWeaveArtifactContext;
import org.mule.runtime.core.el.context.MuleInstanceContext;
import org.mule.runtime.core.el.context.ServerContext;

public class DataWeaveExpressionLanguageAdaptor
implements ExtendedExpressionLanguageAdaptor {
    public static final String SERVER = "server";
    public static final String MULE = "mule";
    public static final String APP = "app";
    private ExpressionLanguage expressionExecutor;
    private MuleContext muleContext;

    public static DataWeaveExpressionLanguageAdaptor create(MuleContext muleContext) {
        try {
            return new DataWeaveExpressionLanguageAdaptor(muleContext, muleContext.getRegistry().lookupObject(DefaultExpressionLanguageFactoryService.class));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unable to obtain expression executor."), (Throwable)e);
        }
    }

    @Inject
    public DataWeaveExpressionLanguageAdaptor(MuleContext muleContext, DefaultExpressionLanguageFactoryService service) {
        this.expressionExecutor = service.create();
        this.muleContext = muleContext;
        this.registerGlobalBindings();
    }

    private void registerGlobalBindings() {
        BindingContext.Builder contextBuilder = BindingContext.builder();
        contextBuilder.addBinding(MULE, new TypedValue<MuleInstanceContext>(new MuleInstanceContext(this.muleContext), DataType.fromType(MuleInstanceContext.class)));
        contextBuilder.addBinding(SERVER, new TypedValue<ServerContext>(new ServerContext(), DataType.fromType(ServerContext.class)));
        contextBuilder.addBinding(APP, new TypedValue<DataWeaveArtifactContext>(new DataWeaveArtifactContext(this.muleContext), DataType.fromType(DataWeaveArtifactContext.class)));
        this.addGlobalBindings(contextBuilder.build());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionExecutor.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event.getMessage().getPayload();
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    private boolean isPayloadExpression(String sanitized) {
        return sanitized.equals("payload");
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, InternalEvent event, BindingContext context) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, InternalEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, componentLocation, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event != null ? event.getMessage().getPayload() : (context != null ? (TypedValue)context.lookup("payload").orElse(null) : null);
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(this.sanitize(expression));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(componentLocation, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(null, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public void enrich(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, Object object) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    @Override
    public void enrich(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, TypedValue value) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    private <T> T sanitizeAndEvaluate(String expression, Function<String, T> evaluation) {
        return this.evaluate(this.sanitize(expression), evaluation);
    }

    private <T> T evaluate(String expression, Function<String, T> evaluation) {
        try {
            return evaluation.apply(expression);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    private BindingContext.Builder bindingContextBuilderFor(ComponentLocation componentLocation, InternalEvent event, BindingContext context) {
        BindingContext.Builder contextBuilder = event != null ? BindingContext.builder(BindingContextUtils.addEventBindings(event, context)) : BindingContext.builder(context);
        if (componentLocation != null) {
            contextBuilder.addBinding("flow", new TypedValue<FlowVariablesAccessor>(new FlowVariablesAccessor(componentLocation.getRootContainerName()), DataType.fromType(FlowVariablesAccessor.class)));
        }
        return contextBuilder;
    }

    private String sanitize(String expression) {
        String sanitizedExpression;
        String string = sanitizedExpression = expression.startsWith("#[") ? expression.substring("#[".length(), expression.length() - "]".length()) : expression;
        if (sanitizedExpression.startsWith("dw:") && !sanitizedExpression.substring(DefaultExpressionManager.DW_PREFIX_LENGTH, DefaultExpressionManager.DW_PREFIX_LENGTH + 1).equals(":")) {
            sanitizedExpression = sanitizedExpression.substring(DefaultExpressionManager.DW_PREFIX_LENGTH);
        }
        return sanitizedExpression;
    }

    private class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

