/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.el.mvel.DelegateVariableResolverFactory;
import org.mule.runtime.core.el.mvel.EventVariableResolverFactory;
import org.mule.runtime.core.el.mvel.GlobalVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MVELExpressionExecutor;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.el.mvel.MVELSplitDataIterator;
import org.mule.runtime.core.el.mvel.NullVariableResolverFactory;
import org.mule.runtime.core.el.mvel.StaticVariableResolverFactory;
import org.mule.runtime.core.el.mvel.VariableVariableResolverFactory;
import org.mule.runtime.core.el.mvel.datatype.MvelDataTypeResolver;
import org.mule.runtime.core.el.mvel.datatype.MvelEnricherDataTypePropagator;

public class MVELExpressionLanguage
extends AbstractAnnotatedObject
implements ExtendedExpressionLanguageAdaptor,
Initialisable {
    public static final String OBJECT_FOR_ENRICHMENT = "__object_for_enrichment";
    protected ParserConfiguration parserConfiguration;
    protected MuleContext muleContext;
    protected MVELExpressionExecutor expressionExecutor;
    protected VariableResolverFactory staticContext;
    protected VariableResolverFactory globalContext;
    protected String globalFunctionsString;
    protected String globalFunctionsFile;
    protected Map<String, Function> globalFunctions = new HashMap<String, Function>();
    protected Map<String, String> aliases = new HashMap<String, String>();
    protected Map<String, Class<?>> imports = new HashMap();
    protected boolean autoResolveVariables = true;
    protected MvelDataTypeResolver dataTypeResolver = new MvelDataTypeResolver();
    protected MvelEnricherDataTypePropagator dataTypePropagator = new MvelEnricherDataTypePropagator();

    @Inject
    public MVELExpressionLanguage(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.parserConfiguration = MVELExpressionLanguage.createParserConfiguration(this.imports);
        this.expressionExecutor = new MVELExpressionExecutor(this.parserConfiguration);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.parserConfiguration = MVELExpressionLanguage.createParserConfiguration(this.imports);
        this.expressionExecutor = new MVELExpressionExecutor(this.parserConfiguration);
        this.loadGlobalFunctions();
        this.createStaticContext();
    }

    protected void createStaticContext() {
        this.staticContext = new StaticVariableResolverFactory(this.parserConfiguration, this.muleContext);
        this.globalContext = new GlobalVariableResolverFactory(this.getAliases(), this.getGlobalFunctions(), this.parserConfiguration, this.muleContext);
    }

    protected void loadGlobalFunctions() throws InitialisationException {
        if (this.globalFunctionsFile != null) {
            try {
                this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions(new ExpressionCompiler(IOUtils.getResourceAsString(this.globalFunctionsFile, this.getClass())).compile()));
            }
            catch (IOException e) {
                throw new InitialisationException(CoreMessages.failedToLoad(this.globalFunctionsFile), (Throwable)e, this);
            }
        }
        this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions(new ExpressionCompiler(this.globalFunctionsString).compile()));
    }

    public <T> T evaluateUntyped(String expression, Map<String, Object> vars) {
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        if (vars != null) {
            context.setNextFactory(new CachedMapVariableResolverFactory(vars, new DelegateVariableResolverFactory(this.staticContext, this.globalContext)));
        } else {
            context.setNextFactory(new DelegateVariableResolverFactory(this.staticContext, this.globalContext));
        }
        return this.evaluateInternal(expression, context);
    }

    public <T> T evaluateUntyped(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, Map<String, Object> vars) {
        if (event == null) {
            return this.evaluateUntyped(expression, vars);
        }
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        DelegateVariableResolverFactory innerDelegate = new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(event, eventBuilder));
        DelegateVariableResolverFactory delegate = new DelegateVariableResolverFactory(this.staticContext, new EventVariableResolverFactory(this.parserConfiguration, this.muleContext, event, eventBuilder, componentLocation, innerDelegate));
        if (vars != null) {
            context.setNextFactory(new CachedMapVariableResolverFactory(vars, delegate));
        } else {
            context.setNextFactory(delegate);
        }
        return this.evaluateInternal(expression, context);
    }

    @Override
    public void enrich(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, Object object) {
        expression = MVELExpressionLanguage.removeExpressionMarker(expression);
        expression = this.createEnrichmentExpression(expression);
        this.evaluateUntyped(expression, event, eventBuilder, componentLocation, Collections.singletonMap(OBJECT_FOR_ENRICHMENT, object));
    }

    @Override
    public void enrich(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, TypedValue typedValue) {
        expression = MVELExpressionLanguage.removeExpressionMarker(expression);
        expression = this.createEnrichmentExpression(expression);
        this.evaluateUntyped(expression, event, eventBuilder, componentLocation, Collections.singletonMap(OBJECT_FOR_ENRICHMENT, typedValue.getValue()));
        Serializable compiledExpression = this.expressionExecutor.getCompiledExpression(expression);
        event = eventBuilder.build();
        this.dataTypePropagator.propagate(typedValue, event, eventBuilder, compiledExpression);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        TypedValue evaluate = this.evaluate(expression, event, componentLocation, bindingContext);
        return MVELSplitDataIterator.createFrom(evaluate.getValue());
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        TypedValue evaluate = this.evaluate(expression, event, bindingContext);
        return MVELSplitDataIterator.createFrom(evaluate.getValue());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, BindingContext context) {
        return this.evaluate(expression, event, InternalEvent.builder(event), null, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, InternalEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.evaluate(expression, expectedOutputType, event, null, context, false);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, InternalEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        return this.evaluate(expression, event, componentLocation, context);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext bindingContext) {
        return this.evaluate(expression, event, InternalEvent.builder(event), componentLocation, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext bindingContext) {
        Map<String, Object> bindingMap;
        Object value = this.evaluateUntyped(expression = MVELExpressionLanguage.removeExpressionMarker(expression), event, eventBuilder, componentLocation, bindingMap = bindingContext.identifiers().stream().collect(Collectors.toMap(id -> id, id -> bindingContext.lookup((String)id).get().getValue())));
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        Serializable compiledExpression = this.expressionExecutor.getCompiledExpression(expression);
        DataType dataType = event != null ? this.dataTypeResolver.resolve(value, event, compiledExpression) : DataType.OBJECT;
        return new TypedValue(value, dataType);
    }

    protected <T> T evaluateInternal(String expression, MVELExpressionLanguageContext variableResolverFactory) {
        this.validate(expression);
        expression = MVELExpressionLanguage.removeExpressionMarker(expression);
        try {
            return (T)this.expressionExecutor.execute(expression, variableResolverFactory);
        }
        catch (Exception e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    @Override
    public ValidationResult validate(String expression) {
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                return ValidationResult.failure("Expression string is not an expression", expression);
            }
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            this.expressionExecutor.validate(expression);
        }
        catch (CompileException e) {
            return ValidationResult.failure(e.getMessage(), expression);
        }
        return ValidationResult.success();
    }

    protected MVELExpressionLanguageContext createExpressionLanguageContext() {
        return new MVELExpressionLanguageContext(this.parserConfiguration, this.muleContext);
    }

    public static ParserConfiguration createParserConfiguration(Map<String, Class<?>> imports) {
        ParserConfiguration ParserConfiguration2 = new ParserConfiguration();
        MVELExpressionLanguage.configureParserConfiguration(ParserConfiguration2, imports);
        return ParserConfiguration2;
    }

    protected static void configureParserConfiguration(ParserConfiguration parserConfiguration, Map<String, Class<?>> imports) {
        parserConfiguration.addPackageImport("java.io");
        parserConfiguration.addPackageImport("java.lang");
        parserConfiguration.addPackageImport("java.net");
        parserConfiguration.addPackageImport("java.util");
        parserConfiguration.addImport(BigDecimal.class);
        parserConfiguration.addImport(BigInteger.class);
        parserConfiguration.addImport(DataHandler.class);
        parserConfiguration.addImport(MimeType.class);
        parserConfiguration.addImport(Pattern.class);
        parserConfiguration.addImport(DataType.class);
        parserConfiguration.addImport(AbstractDataTypeBuilderFactory.class);
        for (Map.Entry<String, Class<?>> importEntry : imports.entrySet()) {
            parserConfiguration.addImport(importEntry.getKey(), importEntry.getValue());
        }
    }

    public void setGlobalFunctionsString(String globalFunctionsString) {
        this.globalFunctionsString = globalFunctionsString;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void setImports(Map<String, Class<?>> imports) {
        this.imports = imports;
    }

    public void setAutoResolveVariables(boolean autoResolveVariables) {
        this.autoResolveVariables = autoResolveVariables;
    }

    public void setDataTypeResolver(MvelDataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
    }

    public void addGlobalFunction(String name, Function function) {
        this.globalFunctions.put(name, function);
    }

    public void addImport(String name, Class<?> clazz) {
        this.imports.put(name, clazz);
    }

    public void addAlias(String name, String expression) {
        this.aliases.put(name, expression);
    }

    public void setGlobalFunctionsFile(String globalFunctionsFile) {
        this.globalFunctionsFile = globalFunctionsFile;
    }

    protected VariableResolverFactory createVariableVariableResolverFactory(InternalEvent event, InternalEvent.Builder eventBuilder) {
        if (this.autoResolveVariables) {
            return new VariableVariableResolverFactory(this.parserConfiguration, this.muleContext, event, eventBuilder);
        }
        return new NullVariableResolverFactory();
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public Map<String, Function> getGlobalFunctions() {
        return this.globalFunctions;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public static String removeExpressionMarker(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if (expression.startsWith("mel:")) {
            expression = expression.substring("mel:".length());
        }
        return expression;
    }

    protected String createEnrichmentExpression(String expression) {
        expression = expression.contains("$") ? StringUtils.replace((String)expression, (String)"$", (String)OBJECT_FOR_ENRICHMENT) : expression + "=" + OBJECT_FOR_ENRICHMENT;
        return expression;
    }
}

