/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.el.mvel.MuleBaseVariableResolverFactory;

public class VariableVariableResolverFactory
extends MuleBaseVariableResolverFactory {
    private static final long serialVersionUID = -4433478558175131280L;
    private InternalEvent event;
    private InternalEvent.Builder eventBuilder;

    public VariableVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, InternalEvent event, InternalEvent.Builder eventBuilder) {
        this.event = event;
        this.eventBuilder = eventBuilder;
    }

    @Override
    public boolean isTarget(String name) {
        if (this.event == null) {
            return false;
        }
        return this.event.getVariables().containsKey(name) || this.event.getSession() != null && this.event.getSession().getPropertyNamesAsSet().contains(name);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.event != null && this.event.getVariables().containsKey(name)) {
            return new FlowVariableVariableResolver(name);
        }
        if (this.event != null && this.event.getSession().getPropertyNamesAsSet().contains(name)) {
            return new SessionVariableVariableResolver(name);
        }
        return super.getNextFactoryVariableResolver(name);
    }

    class SessionVariableVariableResolver
    implements VariableResolver {
        private static final long serialVersionUID = 7658449705305592397L;
        private String name;

        public SessionVariableVariableResolver(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return Object.class;
        }

        @Override
        public void setStaticType(Class type) {
        }

        @Override
        public int getFlags() {
            return 0;
        }

        @Override
        public Object getValue() {
            return VariableVariableResolverFactory.this.event.getSession().getProperty(this.name);
        }

        @Override
        public void setValue(Object value) {
            VariableVariableResolverFactory.this.event.getSession().setProperty(this.name, value);
        }
    }

    class FlowVariableVariableResolver
    implements VariableResolver {
        private static final long serialVersionUID = -4847663330454657440L;
        String name;

        public FlowVariableVariableResolver(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return Object.class;
        }

        @Override
        public void setStaticType(Class type) {
        }

        @Override
        public int getFlags() {
            return 0;
        }

        @Override
        public Object getValue() {
            return VariableVariableResolverFactory.this.event.getVariables().get(this.name).getValue();
        }

        @Override
        public void setValue(Object value) {
            VariableVariableResolverFactory.this.eventBuilder.addVariable(this.name, value);
            VariableVariableResolverFactory.this.event = VariableVariableResolverFactory.this.eventBuilder.build();
        }
    }
}

