/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.LifecycleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.internal.registry.TransientRegistry;
import org.reflections.ReflectionUtils;

public class SimpleRegistry
extends TransientRegistry
implements LifecycleRegistry,
Injector {
    private static final String REGISTRY_ID = "org.mule.runtime.core.Registry.Simple";

    public SimpleRegistry(MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.injectFieldDependencies();
        super.doInitialise();
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.lookupObject(key);
    }

    @Override
    protected void doRegisterObject(String key, Object object, Object metadata) throws RegistrationException {
        Object previous = this.doGet(key);
        if (previous != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("An entry already exists for key %s. It will be replaced", key));
            }
            this.unregisterObject(key);
        }
        this.doPut(key, object);
        try {
            this.getLifecycleManager().applyCompletedPhases(object);
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, startPhase, toPhase);
    }

    @Override
    public <T> T inject(T object) {
        return (T)this.applyProcessors(object, null);
    }

    @Override
    protected Object applyProcessors(Object object, Object metadata) {
        return this.injectInto(super.applyProcessors(object, metadata));
    }

    private void injectFieldDependencies() throws InitialisationException {
        this.lookupObjects(Object.class).forEach(this::injectInto);
    }

    private <T> T injectInto(T object) {
        for (Field field : ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            Class<?> dependencyType = field.getType();
            Named nameAnnotation = field.getAnnotation(Named.class);
            try {
                field.setAccessible(true);
                Object dependency = nameAnnotation != null ? this.lookupObject(nameAnnotation.value()) : this.lookupObject(dependencyType);
                if (dependency == null && MuleContext.class.isAssignableFrom(dependencyType)) {
                    dependency = this.muleContext;
                }
                if (dependency == null) continue;
                field.set(object, dependency);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on field %s of type %s", field.getName(), object.getClass().getName()), e);
            }
        }
        return object;
    }
}

