/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.context.notification;

import org.mule.runtime.core.api.context.notification.Notification;
import org.mule.runtime.core.api.context.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;

public class OptimisedNotificationHandler
implements ServerNotificationHandler {
    private ServerNotificationHandler delegate;
    private Class<? extends Notification> type;
    private boolean dynamic = false;
    private volatile Boolean enabled = null;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class<? extends Notification> type) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
    }

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isListenerRegistered(NotificationListener listener) {
        return this.delegate.isListenerRegistered(listener);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends Notification> notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            if (this.enabled == null) {
                this.enabled = this.delegate.isNotificationEnabled(notfnClass);
            }
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    @Override
    public void fireNotification(Notification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }
}

