/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ToolingApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ToolingApplicationClassLoaderBuilder> {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactClassLoader parentClassLoader;

    public ToolingApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public ToolingArtifactClassLoader build() throws IOException {
        ArtifactClassLoader ownerArtifactClassLoader = super.build();
        ClassLoader parent = ownerArtifactClassLoader.getClassLoader().getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("The parent of the current owner must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        RegionClassLoader regionClassLoader = (RegionClassLoader)parent;
        return new ToolingArtifactClassLoader(regionClassLoader, ownerArtifactClassLoader);
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return ToolingApplicationClassLoaderBuilder.getApplicationId(artifactDescriptor.getName());
    }

    public ToolingApplicationClassLoaderBuilder setParentClassLoader(ArtifactClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public static String getApplicationId(String applicationName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)applicationName), "applicationName cannot be empty");
        return "tooling-application/" + applicationName;
    }
}

