/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import java.util.function.Function;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

public class StereotypeTypeAnnotation
implements TypeAnnotation {
    public static final String NAME = "stereotype";
    private StereotypeModel stereotypeModel;
    private transient Class<? extends StereotypeDefinition> definitionClass;

    public StereotypeTypeAnnotation(Class<? extends StereotypeDefinition> definitionClass) {
        this.definitionClass = definitionClass;
    }

    public StereotypeTypeAnnotation(StereotypeModel stereotypeModel) {
        this.stereotypeModel = stereotypeModel;
    }

    public StereotypeModel getStereotypeModel() {
        Preconditions.checkState(this.stereotypeModel != null, "The stereotypeModel has not yet been resolved");
        return this.stereotypeModel;
    }

    public void resolveStereotype(Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        Preconditions.checkState(this.stereotypeModel == null, "The stereotypeModel has already been resolved or provided");
        this.stereotypeModel = resolver.apply(this.definitionClass);
        this.definitionClass = null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isPublic() {
        return true;
    }
}

