/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionMetadataTypeUtils {
    private ExtensionMetadataTypeUtils() {
    }

    public static Optional<String> getId(MetadataType metadataType) {
        return JavaTypeUtils.getId(metadataType);
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType, ClassLoader classloader) {
        if (!metadataType.getMetadataFormat().equals(MetadataFormat.JAVA)) {
            return Optional.empty();
        }
        try {
            return Optional.of(JavaTypeUtils.getType(metadataType, classloader));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String getAlias(ObjectFieldType fieldType) {
        return fieldType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(MetadataTypeUtils.getLocalPart(fieldType));
    }

    public static String getAlias(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getAlias(metadataType, "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElseGet(() -> ExtensionMetadataTypeUtils.getType(metadataType).map(type -> NameUtils.getAliasName(defaultName, type.getAnnotation(Alias.class))).orElse(defaultName));
    }

    public static boolean isFinal(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType).map(type -> Modifier.isFinal(type.getModifiers())).orElse(false);
    }

    public static boolean isMap(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.isAssignableFrom(metadataType, Map.class);
    }

    public static boolean isInputStream(MetadataType type) {
        return ExtensionMetadataTypeUtils.isAssignableFrom(type, InputStream.class);
    }

    public static boolean isFlattenedParameterGroup(MetadataType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    private static boolean isAssignableFrom(MetadataType metadataType, Class<?> type) {
        return ExtensionMetadataTypeUtils.getType(metadataType).map(clazz -> type.isAssignableFrom((Class<?>)clazz)).orElse(false);
    }
}

