/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;

public final class ContentParameterDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                ContentParameterDeclarationEnricher.this.doEnrich(declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                ContentParameterDeclarationEnricher.this.doEnrich(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void doEnrich(ParameterizedDeclaration declaration) {
        List<ParameterDeclaration> contentParameters = this.getContentParameters(declaration.getAllParameters());
        if (contentParameters.isEmpty()) {
            return;
        }
        if (contentParameters.size() == 1) {
            contentParameters.get(0).setParameterRole(ParameterRole.PRIMARY_CONTENT);
        }
        contentParameters.forEach(param -> {
            this.configureDsl((ParameterDeclaration)param);
            if (param.getRole() == ParameterRole.PRIMARY_CONTENT && param.isRequired()) {
                param.setRequired(false);
                param.setDefaultValue("#[payload]");
            }
        });
    }

    private void configureDsl(ParameterDeclaration p) {
        p.setDslConfiguration(ParameterDslConfiguration.builder(p.getDslConfiguration()).allowsReferences(false).allowsInlineDefinition(true).build());
    }

    private List<ParameterDeclaration> getContentParameters(List<ParameterDeclaration> parameters) {
        return parameters.stream().filter(p -> p.getRole() != ParameterRole.BEHAVIOUR).collect(Collectors.toList());
    }
}

