/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.api.persistence.manifest.ExtensionManifestXmlSerializer;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelDiscoverer {
    private static Logger LOGGER = LoggerFactory.getLogger(ArtifactExtensionManagerFactory.class);

    public Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverExtensionModels(ExtensionModelLoaderRepository loaderRepository, List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins) {
        HashSet<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions = new HashSet<Pair<ArtifactPluginDescriptor, ExtensionModel>>();
        artifactPlugins.forEach(artifactPlugin -> {
            String artifactName;
            ClassLoader artifactClassloader;
            Set extensions = descriptorsWithExtensions.stream().map(Pair::getSecond).collect(Collectors.toSet());
            ArtifactPluginDescriptor artifactPluginDescriptor = (ArtifactPluginDescriptor)artifactPlugin.getFirst();
            Optional<LoaderDescriber> loaderDescriber = artifactPluginDescriptor.getExtensionModelDescriptorProperty();
            ExtensionModel extension = loaderDescriber.map(arg_0 -> this.lambda$null$0(loaderRepository, extensions, artifactClassloader = ((ArtifactClassLoader)artifactPlugin.getSecond()).getClassLoader(), artifactName = artifactPluginDescriptor.getName(), arg_0)).orElseGet(() -> this.discoverExtensionThroughManifest((Pair<ArtifactPluginDescriptor, ArtifactClassLoader>)artifactPlugin, extensions, artifactClassloader, artifactName));
            if (extension != null) {
                descriptorsWithExtensions.add(new Pair<ArtifactPluginDescriptor, ExtensionModel>(artifactPluginDescriptor, extension));
            }
        });
        return descriptorsWithExtensions;
    }

    private ExtensionModel discoverExtensionThroughManifest(Pair<ArtifactPluginDescriptor, ArtifactClassLoader> artifactPlugin, Set<ExtensionModel> extensions, ClassLoader artifactClassloader, String artifactName) {
        URL manifest = artifactPlugin.getSecond().findResource("META-INF/extension-manifest.xml");
        if (manifest != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Discovered extension " + artifactName);
            }
            ExtensionManifest extensionManifest = this.parseExtensionManifestXml(manifest);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", extensionManifest.getDescriberManifest().getProperties().get("type"));
            params.put("version", extensionManifest.getVersion());
            return new DefaultJavaExtensionModelLoader().loadExtensionModel(artifactClassloader, DslResolvingContext.getDefault(extensions), params);
        }
        LOGGER.warn("Extension [" + artifactName + "] could not be discovered");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtensionManifest parseExtensionManifestXml(URL manifestUrl) {
        try (InputStream manifestStream = manifestUrl.openStream();){
            ExtensionManifest extensionManifest = new ExtensionManifestXmlSerializer().deserialize(IOUtils.toString((InputStream)manifestStream));
            return extensionManifest;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not read extension manifest on plugin " + manifestUrl.toString()), (Throwable)e);
        }
    }

    private ExtensionModel discoverExtensionThroughJsonDescriber(ExtensionModelLoaderRepository extensionModelLoaderRepository, LoaderDescriber loaderDescriber, Set<ExtensionModel> extensions, ClassLoader artifactClassloader, String artifactName) {
        ExtensionModelLoader loader = extensionModelLoaderRepository.getExtensionModelLoader(loaderDescriber).orElseThrow(() -> new IllegalArgumentException(String.format("The identifier '%s' does not match with the describers available to generate an ExtensionModel (working with the plugin '%s')", loaderDescriber.getId(), artifactName)));
        return loader.loadExtensionModel(artifactClassloader, DslResolvingContext.getDefault(extensions), loaderDescriber.getAttributes());
    }

    private /* synthetic */ ExtensionModel lambda$null$0(ExtensionModelLoaderRepository loaderRepository, Set extensions, ClassLoader artifactClassloader, String artifactName, LoaderDescriber describer) {
        return this.discoverExtensionThroughJsonDescriber(loaderRepository, describer, extensions, artifactClassloader, artifactName);
    }
}

