/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.model.Model;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.ContentGenerator;

public class MavenBundleDescriptorLoader
implements BundleDescriptorLoader {
    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public BundleDescriptor load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (this.isHeavyPackage(artifactFile)) {
            File classLoaderModelDescriptor = this.getClassLoaderModelDescriptor(artifactFile);
            ClassLoaderModel packagerClassLoaderModel = ContentGenerator.createClassLoaderModelFromJson(classLoaderModelDescriptor);
            return new BundleDescriptor.Builder().setArtifactId(packagerClassLoaderModel.getArtifactCoordinates().getArtifactId()).setGroupId(packagerClassLoaderModel.getArtifactCoordinates().getGroupId()).setVersion(packagerClassLoaderModel.getArtifactCoordinates().getVersion()).setType(packagerClassLoaderModel.getArtifactCoordinates().getType()).setClassifier(packagerClassLoaderModel.getArtifactCoordinates().getClassifier()).build();
        }
        Model model = artifactFile.isDirectory() ? MavenUtils.getPomModelFolder(artifactFile) : MavenUtils.getPomModelFromJar(artifactFile);
        return new BundleDescriptor.Builder().setArtifactId(model.getArtifactId()).setGroupId(model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId()).setVersion(model.getVersion() != null ? model.getVersion() : model.getParent().getVersion()).setType("jar").setClassifier("mule-plugin").build();
    }

    private boolean isHeavyPackage(File artifactFile) {
        return this.getClassLoaderModelDescriptor(artifactFile).exists();
    }

    protected File getClassLoaderModelDescriptor(File artifactFile) {
        if (artifactFile.isDirectory()) {
            return new File(artifactFile, AbstractMavenClassLoaderModelLoader.CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
        }
        return new File(artifactFile.getParent(), "classloader-model.json");
    }
}

