/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.tooling;

import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExtensionConnectivityTestingStrategy
implements ConnectivityTestingStrategy {
    @Inject
    private MuleContext muleContext;
    @Inject
    private ConnectionManager connectionManager;

    public ExtensionConnectivityTestingStrategy() {
    }

    ExtensionConnectivityTestingStrategy(ConnectionManager connectionManager, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionValidationResult testConnectivity(Object connectivityTestingObject) {
        try {
            if (connectivityTestingObject instanceof ConnectionProviderResolver) {
                ConnectionProvider connectionProvider = (ConnectionProvider)((Pair)((ConnectionProviderResolver)connectivityTestingObject).resolve(ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent(this.muleContext)))).getFirst();
                return this.connectionManager.testConnectivity(connectionProvider);
            }
            if (connectivityTestingObject instanceof ConfigurationProvider) {
                ConfigurationProvider configurationProvider = (ConfigurationProvider)connectivityTestingObject;
                ConfigurationInstance configurationInstance = configurationProvider.get(MuleExtensionUtils.getInitialiserEvent(this.muleContext));
                return this.connectionManager.testConnectivity(configurationInstance);
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("testConnectivity was invoked with an object type %s not supported.", connectivityTestingObject.getClass().getName())));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure("Failed to obtain connectivity testing object", e);
        }
    }

    @Override
    public boolean accepts(Object connectivityTestingObject) {
        return connectivityTestingObject instanceof ConnectionProviderResolver || connectivityTestingObject instanceof ConfigurationProvider;
    }
}

