/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.config.spring.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Schema;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

final class ConfigurationSchemaDelegate {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;
    private Schema schema;

    ConfigurationSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
    }

    void registerConfigElement(Schema schema, ConfigurationModel configurationModel, DslElementSyntax dslConfigElement) {
        this.schema = schema;
        ExtensionType config = this.registerExtension(dslConfigElement.getElementName());
        config.getAttributeOrAttributeGroup().add(this.builder.createNameAttribute(true));
        config.setAnnotation(this.builder.createDocAnnotation(configurationModel.getDescription()));
        Optional<TopLevelElement> connectionElement = this.addConnectionProviderElement(configurationModel);
        Optional<TopLevelElement> policyElement = this.addDynamicConfigPolicyElement(configurationModel);
        if (connectionElement.isPresent() || policyElement.isPresent() || !configurationModel.getParameterGroupModels().isEmpty()) {
            ExplicitGroup sequence = new ExplicitGroup();
            sequence.setMinOccurs(BigInteger.ZERO);
            sequence.setMaxOccurs("1");
            connectionElement.ifPresent(connection -> {
                sequence.getParticle().add(this.objectFactory.createElement((TopLevelElement)connection));
                if (this.builder.isRequired((TopLevelElement)connection)) {
                    sequence.setMinOccurs(BigInteger.ONE);
                }
            });
            policyElement.ifPresent(policy -> {
                sequence.getParticle().add(this.objectFactory.createElement((TopLevelElement)policy));
                if (this.builder.isRequired((TopLevelElement)policy)) {
                    sequence.setMinOccurs(BigInteger.ONE);
                }
            });
            this.builder.addInfrastructureParameters(config, configurationModel, sequence);
            configurationModel.getParameterGroupModels().forEach(group -> {
                if (!group.isShowInDsl()) {
                    List<TopLevelElement> parameters = this.builder.registerParameters(config, group.getParameterModels());
                    this.builder.addParameterToSequence(parameters, sequence);
                } else {
                    this.builder.addInlineParameterGroup((ParameterGroupModel)group, sequence);
                }
            });
            config.setSequence(sequence);
        }
    }

    private ExtensionType registerExtension(String name) {
        LocalComplexType complexType = new LocalComplexType();
        TopLevelElement extension = new TopLevelElement();
        extension.setName(name);
        extension.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_SHARED_EXTENSION);
        extension.setComplexType(complexType);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        complexContent.setExtension(complexContentExtension);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(extension);
        return complexContentExtension;
    }

    private Optional<TopLevelElement> addConnectionProviderElement(ConfigurationModel configurationModel) {
        ExtensionModel extensionModel = this.builder.getExtensionModel();
        if (!extensionModel.getConnectionProviders().isEmpty() || !configurationModel.getConnectionProviders().isEmpty()) {
            TopLevelElement objectElement = new TopLevelElement();
            boolean hasImplicitConnection = ExtensionModelUtils.getFirstImplicit(extensionModel.getConnectionProviders()) != null || ExtensionModelUtils.getFirstImplicit(configurationModel.getConnectionProviders()) != null;
            objectElement.setMinOccurs(hasImplicitConnection ? BigInteger.ZERO : BigInteger.ONE);
            objectElement.setMaxOccurs("1");
            objectElement.setRef(SchemaConstants.MULE_EXTENSION_CONNECTION_PROVIDER_ELEMENT);
            return Optional.of(objectElement);
        }
        return Optional.empty();
    }

    private Optional<TopLevelElement> addDynamicConfigPolicyElement(ConfigurationModel configurationModel) {
        if (!ExtensionModelUtils.getDynamicParameters(configurationModel).isEmpty()) {
            TopLevelElement objectElement = new TopLevelElement();
            objectElement.setMinOccurs(BigInteger.ZERO);
            objectElement.setMaxOccurs("1");
            objectElement.setRef(SchemaConstants.MULE_EXTENSION_DYNAMIC_CONFIG_POLICY_ELEMENT);
            return Optional.of(objectElement);
        }
        return Optional.empty();
    }
}

