/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.model;

import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public final class SchemaTypeConversion {
    public static QName convertType(MetadataType type, ExpressionSupport expressionSupport) {
        final boolean dynamic = ExtensionModelUtils.acceptsExpressions(expressionSupport);
        final Reference<Object> qName = new Reference<Object>(null);
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitBoolean(BooleanType booleanType) {
                qName.set(dynamic ? SchemaConstants.EXPRESSION_BOOLEAN : SchemaConstants.SUBSTITUTABLE_BOOLEAN);
            }

            @Override
            public void visitNumber(NumberType numberType) {
                if (ExtensionMetadataTypeUtils.getId(numberType).isPresent()) {
                    Class<Number> type = JavaTypeUtils.getType(numberType);
                    if (this.anyOf(type, Integer.class, Integer.TYPE)) {
                        qName.set(dynamic ? SchemaConstants.EXPRESSION_INTEGER : SchemaConstants.SUBSTITUTABLE_INT);
                    } else if (this.anyOf(type, Double.class, Double.TYPE)) {
                        qName.set(dynamic ? SchemaConstants.EXPRESSION_DOUBLE : SchemaConstants.SUBSTITUTABLE_DECIMAL);
                    } else if (this.anyOf(type, Long.class, Long.TYPE)) {
                        qName.set(dynamic ? SchemaConstants.EXPRESSION_LONG : SchemaConstants.SUBSTITUTABLE_LONG);
                    } else {
                        qName.set(dynamic ? SchemaConstants.EXPRESSION_DECIMAL : SchemaConstants.SUBSTITUTABLE_DECIMAL);
                    }
                } else if (numberType.getAnnotation(IntAnnotation.class).isPresent()) {
                    qName.set(dynamic ? SchemaConstants.EXPRESSION_INTEGER : SchemaConstants.SUBSTITUTABLE_INT);
                } else {
                    qName.set(dynamic ? SchemaConstants.EXPRESSION_DECIMAL : SchemaConstants.SUBSTITUTABLE_DECIMAL);
                }
            }

            @Override
            public void visitString(StringType stringType) {
                qName.set(dynamic ? SchemaConstants.EXPRESSION_STRING : SchemaConstants.STRING);
            }

            @Override
            public void visitDateTime(DateTimeType dateTimeType) {
                this.onDate();
            }

            @Override
            public void visitDate(DateType dateType) {
                this.onDate();
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                qName.set(dynamic ? SchemaConstants.EXPRESSION_LIST : SchemaConstants.SUBSTITUTABLE_NAME);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    qName.set(dynamic ? SchemaConstants.EXPRESSION_MAP : SchemaConstants.SUBSTITUTABLE_MAP);
                } else {
                    this.defaultVisit(objectType);
                }
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                qName.set(SchemaConstants.STRING);
            }

            private void onDate() {
                qName.set(dynamic ? SchemaConstants.EXPRESSION_DATE_TIME : SchemaConstants.SUBSTITUTABLE_DATE_TIME);
            }

            private boolean anyOf(Class<Number> type, Class<?> ... targets) {
                for (Class<?> target : targets) {
                    if (!type.equals(target)) continue;
                    return true;
                }
                return false;
            }
        });
        return qName.get();
    }
}

