/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public final class MimeTypeParametersDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            new IdempotentDeclarationWalker(){

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    EnricherDelegate.this.declareMimeTypeParameters(declaration);
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    EnricherDelegate.this.declareMimeTypeParameters(declaration);
                }
            }.walk(declaration);
        }

        private void declareOutputEncodingParameter(ParameterGroupDeclaration group) {
            group.addParameter(this.newParameter("outputEncoding", "The encoding of the payload that this operation outputs."));
        }

        private void declareOutputMimeTypeParameter(ParameterGroupDeclaration group) {
            group.addParameter(this.newParameter("outputMimeType", "The mime type of the payload that this operation outputs."));
        }

        private void declareMimeTypeParameters(final ExecutableComponentDeclaration declaration) {
            declaration.getOutput().getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitString(StringType stringType) {
                    if (!stringType.getAnnotation(EnumAnnotation.class).isPresent()) {
                        EnricherDelegate.this.declareOutputMimeTypeParameter(declaration.getParameterGroup("General"));
                    }
                }

                @Override
                public void visitBinaryType(BinaryType binaryType) {
                    ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                    EnricherDelegate.this.declareOutputMimeTypeParameter(group);
                    EnricherDelegate.this.declareOutputEncodingParameter(group);
                }
            });
        }

        private ParameterDeclaration newParameter(String name, String description) {
            ParameterDeclaration parameter = new ParameterDeclaration(name);
            parameter.setRequired(false);
            parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
            parameter.setType(this.typeLoader.load((Type)((Object)String.class)), false);
            parameter.setDescription(description);
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            return parameter;
        }
    }
}

