/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.process.Chain;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.property.OperationExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.ResolvableType;

final class OperationModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String OPERATION = "Operation";
    private static final String SCOPE = "Scope";
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();

    OperationModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer.getDeclaringClass(), operationsContainer.getOperations(), true);
    }

    private boolean isScope(MethodElement methodElement) {
        return methodElement.getParameters().stream().anyMatch(this::isProcessorChain);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, Class<?> methodOwnerClass, List<MethodElement> operations, boolean supportsConfig) {
        for (MethodElement operationMethod : operations) {
            Class declaringClass = methodOwnerClass != null ? methodOwnerClass : operationMethod.getDeclaringClass();
            this.checkOperationIsNotAnExtension(declaringClass);
            Method method = operationMethod.getMethod();
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(operationMethod);
            Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(operationMethod);
            this.checkDefinition(!this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter), String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", method.getName()));
            HasOperationDeclarer actualDeclarer = this.selectDeclarer(extensionDeclarer, (Declarer)((Object)ownerDeclarer), operationMethod, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operationDeclarer = (OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(operationMethod.getAlias()).withModelProperty(new ImplementingMethodModelProperty(method))).withModelProperty(new OperationExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
            this.loader.addExceptionEnricher(operationMethod, operationDeclarer);
            if (this.isScope(operationMethod)) {
                this.declareScope(operationDeclarer, operationMethod, method, configParameter, connectionParameter);
            } else {
                this.declareOperation(operationDeclarer, supportsConfig, operationMethod, method);
            }
            this.operationDeclarers.put(operationMethod, operationDeclarer);
        }
    }

    private void declareScope(OperationDeclarer scope, MethodElement scopeMethod, Method method, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        this.checkDefinition(!configParameter.isPresent(), String.format("Scope '%s' requires a config, but that is not allowed, remove such parameter", method.getName()));
        this.checkDefinition(!connectionParameter.isPresent(), String.format("Scope '%s' requires a connection, but that is not allowed, remove such parameter", method.getName()));
        this.checkDefinition(this.isNonBlocking(scopeMethod), String.format("Scope '%s' does not declare a '%s' parameter. One is required for all operations that receive and execute a Chain of other components", scopeMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        this.processNonBlockingOperation(scope, scopeMethod, false);
        this.loader.getMethodParametersLoader().declare(scope, scopeMethod.getParameters(), new ParameterDeclarationContext(SCOPE, (NamedDeclaration)scope.getDeclaration()));
        List processorChain = scopeMethod.getParameters().stream().filter(this::isProcessorChain).collect(Collectors.toList());
        this.checkDefinition(processorChain.size() <= 1, String.format("Scope '%s' declares too many parameters of type '%s', only one input of this kind is supported.Offending parameters are: %s", scopeMethod.getAlias(), Chain.class.getSimpleName(), processorChain.stream().map(NamedObject::getName).collect(Collectors.toList())));
        ExtensionParameter chainParameter = (ExtensionParameter)processorChain.get(0);
        ((NestedChainDeclarer)scope.withChain(chainParameter.getAlias()).describedAs(chainParameter.getDescription())).setRequired(chainParameter.isRequired());
    }

    private boolean isProcessorChain(ExtensionParameter parameter) {
        return Chain.class.equals((Object)parameter.getType().getDeclaringClass());
    }

    private void declareOperation(OperationDeclarer operation, boolean supportsConfig, MethodElement operationMethod, Method method) {
        this.processComponentConnectivity(operation, operationMethod, operationMethod);
        if (this.isNonBlocking(operationMethod)) {
            this.processNonBlockingOperation(operation, operationMethod, true);
        } else {
            this.processBlockingOperation(supportsConfig, operationMethod, method, operation);
        }
        this.addExecutionType(operation, operationMethod);
        ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operation.getDeclaration());
        this.loader.getMethodParametersLoader().declare(operation, operationMethod.getParameters(), declarationContext);
    }

    private void processBlockingOperation(boolean supportsConfig, MethodElement operationMethod, Method method, OperationDeclarer operation) {
        operation.blocking(true);
        operation.withOutputAttributes().ofType(IntrospectionUtils.getMethodReturnAttributesType(method, this.loader.getTypeLoader()));
        if (this.isAutoPaging(operationMethod)) {
            ((OperationDeclarer)operation.supportsStreaming(true)).withOutput().ofType(IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader()));
            this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
            this.processPagingTx(operation, method);
        } else {
            MetadataType outputType = IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader());
            operation.withOutput().ofType(outputType);
            this.handleByteStreaming(method, operation, outputType);
        }
    }

    private void handleByteStreaming(Method method, ExecutableComponentDeclarer executableComponent, MetadataType outputType) {
        executableComponent.supportsStreaming(ExtensionMetadataTypeUtils.isInputStream(outputType) || method.getAnnotation(Streaming.class) != null);
    }

    private HasOperationDeclarer selectDeclarer(ExtensionDeclarer extensionDeclarer, Declarer declarer, MethodElement operationMethod, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        if (this.isAutoPaging(operationMethod)) {
            return (HasOperationDeclarer)((Object)declarer);
        }
        return (HasOperationDeclarer)((Object)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, declarer, configParameter, connectionParameter));
    }

    private boolean isNonBlocking(MethodElement method) {
        return method.getParameters().stream().anyMatch(p -> CompletionCallback.class.equals((Object)p.getType().getDeclaringClass()));
    }

    private void processNonBlockingOperation(OperationDeclarer operation, MethodElement operationMethod, boolean allowStreaming) {
        List callbackParameters = operationMethod.getParameters().stream().filter(p -> CompletionCallback.class.equals((Object)p.getType().getDeclaringClass())).collect(Collectors.toList());
        this.checkDefinition(!callbackParameters.isEmpty(), String.format("Operation '%s' does not declare a '%s' parameter. One is required for a non-blocking operation", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        this.checkDefinition(callbackParameters.size() <= 1, String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        this.checkDefinition(IntrospectionUtils.isVoid(operationMethod.getMethod()), String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        ExtensionParameter callbackParameter = (ExtensionParameter)callbackParameters.get(0);
        Parameter methodParameter = (Parameter)callbackParameter.getDeclaringElement();
        List<MetadataType> genericTypes = IntrospectionUtils.getGenerics(methodParameter.getParameterizedType(), this.loader.getTypeLoader());
        if (genericTypes.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Generics are mandatory on the %s parameter of Operation '%s'", CompletionCallback.class.getSimpleName(), operationMethod.getAlias()));
        }
        operation.withOutput().ofType(genericTypes.get(0));
        operation.withOutputAttributes().ofType(genericTypes.get(1));
        operation.blocking(false);
        if (allowStreaming) {
            this.handleByteStreaming(operationMethod.getMethod(), operation, genericTypes.get(0));
        } else {
            operation.supportsStreaming(false);
        }
    }

    private void addExecutionType(OperationDeclarer operationDeclarer, MethodElement operationMethod) {
        operationMethod.getAnnotation(Execution.class).ifPresent(a -> operationDeclarer.withExecutionType(a.value()));
    }

    private void checkOperationIsNotAnExtension(Class<?> operationType) {
        if (operationType.isAssignableFrom(this.getExtensionType()) || this.getExtensionType().isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.getExtensionType().getName()));
        }
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        this.checkDefinition(supportsConfig, String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
        operation.withModelProperty(new PagedOperationModelProperty());
        operation.requiresConnection(true);
    }

    private void processPagingTx(OperationDeclarer operation, Method method) {
        Preconditions.checkArgument(method != null, "Can't introspect a null method");
        ResolvableType connectionType = ResolvableType.forMethodReturnType((Method)method).getGeneric(new int[]{0});
        operation.transactional(TransactionalConnection.class.isAssignableFrom(connectionType.getRawClass()));
    }

    private boolean isAutoPaging(MethodElement operationMethod) {
        return PagingProvider.class.isAssignableFrom(operationMethod.getReturnType());
    }

    private void checkDefinition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalOperationModelDefinitionException(message);
        }
    }
}

