/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.config.ExpirableConfigurationProvider;
import org.mule.runtime.module.extension.internal.manager.ExtensionEntityKey;

final class ExtensionRegistry {
    private final LoadingCache<ExtensionModel, Multimap<ConfigurationModel, ConfigurationProvider>> providersByExtension = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ExtensionModel, Multimap<ConfigurationModel, ConfigurationProvider>>(){

        public Multimap<ConfigurationModel, ConfigurationProvider> load(ExtensionModel key) throws Exception {
            List<ConfigurationProvider> providers = ExtensionRegistry.this.registry.lookupObjects(ConfigurationProvider.class).stream().filter(provider -> provider.getExtensionModel() == key).collect(Collectors.toImmutableList());
            HashMultimap multimap = HashMultimap.create();
            providers.forEach(arg_0 -> 1.lambda$load$1((Multimap)multimap, arg_0));
            return multimap;
        }

        private static /* synthetic */ void lambda$load$1(Multimap multimap, ConfigurationProvider p) {
            multimap.put((Object)p.getConfigurationModel(), (Object)p);
        }
    });
    private final Map<ExtensionEntityKey, ExtensionModel> extensions = new ConcurrentHashMap<ExtensionEntityKey, ExtensionModel>();
    private final MuleRegistry registry;

    ExtensionRegistry(MuleRegistry registry) {
        this.registry = registry;
    }

    void registerExtension(String name, ExtensionModel extensionModel) {
        this.extensions.put(new ExtensionEntityKey(name), extensionModel);
    }

    Set<ExtensionModel> getExtensions() {
        return ImmutableSet.copyOf(this.extensions.values());
    }

    Optional<ExtensionModel> getExtension(String extensionName) {
        return Optional.ofNullable(this.extensions.get(new ExtensionEntityKey(extensionName)));
    }

    boolean containsExtension(String name) {
        return this.extensions.containsKey(new ExtensionEntityKey(name));
    }

    Collection<ConfigurationProvider> getConfigurationProviders(ExtensionModel extensionModel) {
        return ((Multimap)this.providersByExtension.getUnchecked((Object)extensionModel)).values();
    }

    Optional<ConfigurationProvider> getConfigurationProvider(String key) {
        return Optional.ofNullable(this.registry.get(key));
    }

    void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        Preconditions.checkArgument(configurationProvider != null, "Cannot register a null configurationProvider");
        try {
            this.registry.registerObject(configurationProvider.getName(), configurationProvider);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Found exception while registering configuration provider '%s'", configurationProvider.getName())), (Throwable)e);
        }
        this.providersByExtension.invalidate((Object)configurationProvider.getExtensionModel());
    }

    Multimap<String, ConfigurationInstance> getExpiredConfigs() {
        ArrayListMultimap expired = ArrayListMultimap.create();
        for (ExtensionModel extensionModel : this.extensions.values()) {
            this.getConfigurationProviders(extensionModel).stream().filter(provider -> provider instanceof ExpirableConfigurationProvider).forEach(arg_0 -> ExtensionRegistry.lambda$getExpiredConfigs$1((ListMultimap)expired, arg_0));
        }
        return Multimaps.unmodifiableListMultimap((ListMultimap)expired);
    }

    private static /* synthetic */ void lambda$getExpiredConfigs$1(ListMultimap expired, ConfigurationProvider provider) {
        expired.putAll((Object)provider.getName(), ((ExpirableConfigurationProvider)provider).getExpired());
    }
}

