/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.Chain;
import org.mule.runtime.module.extension.internal.runtime.operation.EventedResult;
import reactor.core.publisher.Mono;

public class ImmutableProcessorChainExecutor
implements Chain,
Initialisable {
    private MessageProcessorChain chain;
    private final InternalEvent originalEvent;
    private InternalEvent currentEvent;
    private Consumer<Result> successHandler;
    private BiConsumer<Throwable, Result> errorHandler;

    public ImmutableProcessorChainExecutor(InternalEvent event, MessageProcessorChain chain) {
        this.originalEvent = event;
        this.currentEvent = event;
        this.chain = chain;
    }

    @Override
    public void process(Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.doProcess(this.originalEvent, onSuccess, onError);
    }

    @Override
    public void process(Object payload, Object attributes, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        InternalEvent customEvent = InternalEvent.builder(this.originalEvent).message(Message.builder().payload(TypedValue.of(payload)).attributes(TypedValue.of(attributes)).build()).build();
        this.doProcess(customEvent, onSuccess, onError);
    }

    @Override
    public void process(Result result, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        if (result instanceof EventedResult) {
            this.currentEvent = ((EventedResult)result).getEvent();
            this.doProcess(this.currentEvent, onSuccess, onError);
        } else {
            this.process(result.getOutput(), result.getAttributes(), onSuccess, onError);
        }
    }

    private void setHandlers(Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        Preconditions.checkArgument(onSuccess != null, "A success completion handler is required in order to execute the components chain, but it was null");
        Preconditions.checkArgument(onError != null, "An error completion handler is required in order to execute the components chain, but it was null");
        this.successHandler = onSuccess;
        this.errorHandler = onError;
    }

    private void doProcess(InternalEvent updatedEvent, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.setHandlers(onSuccess, onError);
        Mono.from(MessageProcessors.processWithChildContext(updatedEvent, this.chain, Optional.ofNullable(this.chain.getLocation()))).doOnSuccess(this::handleSuccess).doOnError(MessagingException.class, error -> this.handleError((Throwable)error, error.getEvent())).doOnError(error -> this.handleError((Throwable)error, this.currentEvent)).subscribe();
    }

    private void handleSuccess(InternalEvent childEvent) {
        Result result = childEvent != null ? EventedResult.from(childEvent) : Result.builder().build();
        try {
            this.successHandler.accept(result);
        }
        catch (Throwable error) {
            this.errorHandler.accept(error, result);
        }
    }

    private InternalEvent handleError(Throwable error, InternalEvent childEvent) {
        try {
            this.errorHandler.accept(error, EventedResult.from(childEvent));
        }
        catch (Throwable e) {
            this.originalEvent.getContext().error(e);
        }
        return null;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.chain);
    }
}

