/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class OperationParameterValueResolver
implements ParameterValueResolver {
    private final OperationModel operationModel;
    private final ExecutionContext<OperationModel> executionContext;
    private final Map<String, String> showInDslParameters;

    OperationParameterValueResolver(ExecutionContext<OperationModel> executionContext) {
        this.executionContext = executionContext;
        this.operationModel = executionContext.getComponentModel();
        this.showInDslParameters = this.getShowInDslParameters();
    }

    @Override
    public Object getParameterValue(String parameterName) {
        return this.getParameterGroup(parameterName).map(group -> new ParameterGroupArgumentResolver((ParameterGroupDescriptor)group).resolve(this.executionContext)).orElseGet(() -> {
            String showInDslGroupName = this.showInDslParameters.get(parameterName);
            return showInDslGroupName != null ? this.getShowInDslParameterValue(parameterName, showInDslGroupName) : this.executionContext.getParameter(parameterName);
        });
    }

    private Optional<ParameterGroupDescriptor> getParameterGroup(String parameterGroupName) {
        return this.operationModel.getParameterGroupModels().stream().filter(group -> group.getName().equals(parameterGroupName) && !group.isShowInDsl()).findFirst().map(group -> group.getModelProperty(ParameterGroupModelProperty.class)).filter(Optional::isPresent).map(group -> ((ParameterGroupModelProperty)group.get()).getDescriptor());
    }

    private Object getShowInDslParameterValue(String parameterName, String showInDslGroupName) {
        Object group = this.executionContext.getParameter(showInDslGroupName);
        try {
            return IntrospectionUtils.getFieldValue(group, parameterName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(String.format("An error occurred trying to obtain the field '%s' from the group '%s' of the Operation '%s'", parameterName, showInDslGroupName, this.operationModel.getName()));
        }
    }

    private Map<String, String> getShowInDslParameters() {
        HashMap<String, String> showInDslMap = new HashMap<String, String>();
        this.operationModel.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).forEach(groupModel -> groupModel.getParameterModels().forEach(param -> showInDslMap.put(IntrospectionUtils.getImplementingName(param), IntrospectionUtils.getGroupModelContainerName(groupModel))));
        return showInDslMap;
    }
}

