/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ObjectBuilderValueResolver<T>
extends AbstractAnnotatedObject
implements ValueResolver<T>,
Initialisable {
    private final ObjectBuilder<T> builder;
    private final MuleContext muleContext;

    public ObjectBuilderValueResolver(ObjectBuilder<T> builder, MuleContext muleContext) {
        Preconditions.checkArgument(builder != null, "builder cannot be null");
        this.builder = builder;
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.builder.build(context);
    }

    @Override
    public boolean isDynamic() {
        return this.builder.isDynamic();
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.builder, true, this.muleContext);
    }
}

