/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Header;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.introspection.WsdlDefinition;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.metadata.SoapHeaderAdapter;
import org.mule.service.soap.metadata.TypeIntrospecterDelegate;

final class HeadersMetadataResolver
extends NodeMetadataResolver {
    HeadersMetadataResolver(WsdlDefinition definition, TypeLoader loader) {
        super(definition, loader);
    }

    @Override
    public MetadataType getMetadata(String operation, TypeIntrospecterDelegate delegate) throws MetadataResolvingException {
        BindingOperation bindingOperation = this.definition.getBindingOperation(operation);
        ElementExtensible bindingType = delegate.getBindingType(bindingOperation);
        List<SoapHeaderAdapter> headers = this.getHeaderParts(bindingType);
        if (!headers.isEmpty()) {
            Message message = delegate.getMessage(this.definition.getOperation(operation));
            return this.buildHeaderType(headers, message);
        }
        return this.nullType;
    }

    private MetadataType buildHeaderType(List<SoapHeaderAdapter> headers, Message message) throws MetadataResolvingException {
        ObjectTypeBuilder objectType = this.typeBuilder.objectType();
        for (SoapHeaderAdapter header : headers) {
            ObjectFieldTypeBuilder field = objectType.addField();
            String headerPart = header.getPart();
            Part part = message.getPart(headerPart);
            if (part != null) {
                field.key(headerPart).value(this.buildPartMetadataType(part));
                continue;
            }
            Message headerMessage = this.definition.getMessage(header.getMessage());
            field.key(headerPart).value(this.buildPartMetadataType(headerMessage.getPart(headerPart)));
        }
        return objectType.build();
    }

    private List<SoapHeaderAdapter> getHeaderParts(ElementExtensible bindingType) {
        List extensible = bindingType.getExtensibilityElements();
        if (extensible != null) {
            return extensible.stream().filter(e -> e instanceof SOAPHeader || e instanceof SOAP12Header).map(e -> e instanceof SOAPHeader ? new SoapHeaderAdapter((SOAPHeader)e) : new SoapHeaderAdapter((SOAP12Header)e)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

