/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.tools.api.classloader.model.ApplicationClassloaderModel;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;

public class ApplicationClassLoaderModelAssembler {
    private static final String POM_TYPE = "pom";
    private static final String CLASS_LOADER_MODEL_VERSION = "1.0.0";
    private static final String PACKAGE_TYPE = "jar";
    private final AetherMavenClient muleMavenPluginClient;
    private ApplicationClassloaderModel applicationClassLoaderModel;

    public ApplicationClassLoaderModelAssembler(AetherMavenClient muleMavenPluginClient) {
        this.muleMavenPluginClient = muleMavenPluginClient;
    }

    public ApplicationClassloaderModel getApplicationClassLoaderModel(File pomFile, File targetFolder) throws IllegalStateException {
        ArtifactCoordinates appCoordinates = this.getApplicationArtifactCoordinates(pomFile);
        ClassLoaderModel appModel = new ClassLoaderModel(CLASS_LOADER_MODEL_VERSION, appCoordinates);
        BundleDescriptor pomBundleDescriptor = this.getPomProjectBundleDescriptor(pomFile);
        List<BundleDependency> appDependencies = this.resolveApplicationDependencies(targetFolder, pomBundleDescriptor);
        List<BundleDependency> mulePlugins = appDependencies.stream().filter(dep -> dep.getDescriptor().getClassifier().isPresent()).filter(dep -> dep.getDescriptor().getClassifier().get().equals("mule-plugin")).collect(Collectors.toList());
        appModel.setDependencies(ArtifactUtils.toArtifacts(appDependencies));
        this.applicationClassLoaderModel = new ApplicationClassloaderModel(appModel);
        Map<BundleDependency, List<BundleDependency>> mulePluginDependencies = this.resolveMulePluginDependencies(mulePlugins);
        for (Map.Entry<BundleDependency, List<BundleDependency>> mulePluginEntry : mulePluginDependencies.entrySet()) {
            ClassLoaderModel mulePluginClassloaderModel = new ClassLoaderModel(CLASS_LOADER_MODEL_VERSION, ArtifactUtils.toArtifactCoordinates(mulePluginEntry.getKey().getDescriptor()));
            mulePluginClassloaderModel.setDependencies(ArtifactUtils.toArtifacts((Collection<BundleDependency>)mulePluginEntry.getValue()));
            this.applicationClassLoaderModel.addMulePluginClassloaderModel(mulePluginClassloaderModel);
        }
        return this.applicationClassLoaderModel;
    }

    protected ArtifactCoordinates getApplicationArtifactCoordinates(File pomFile) {
        ArtifactCoordinates appCoordinates = ArtifactUtils.toArtifactCoordinates(this.getPomProjectBundleDescriptor(pomFile));
        appCoordinates.setType(PACKAGE_TYPE);
        appCoordinates.setClassifier(MavenUtils.getPomModelFromFile(pomFile).getPackaging());
        return appCoordinates;
    }

    protected BundleDescriptor getPomProjectBundleDescriptor(File pomFile) {
        Model pomModel = MavenUtils.getPomModelFromFile(pomFile);
        return this.getBundleDescriptor(pomModel);
    }

    private List<BundleDependency> resolveApplicationDependencies(File targetFolder, BundleDescriptor projectBundleDescriptor) {
        return this.muleMavenPluginClient.resolveBundleDescriptorDependenciesWithWorkspaceReader(targetFolder, false, false, projectBundleDescriptor);
    }

    private Map<BundleDependency, List<BundleDependency>> resolveMulePluginDependencies(List<BundleDependency> mulePlugins) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> muleDependenciesDependencies = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency muleDependency : mulePlugins) {
            List<BundleDependency> mulePluginDependencies = this.muleMavenPluginClient.resolveBundleDescriptorDependencies(false, false, muleDependency.getDescriptor());
            muleDependenciesDependencies.put(muleDependency, new ArrayList<BundleDependency>(mulePluginDependencies));
        }
        return muleDependenciesDependencies;
    }

    protected BundleDescriptor getBundleDescriptor(Model pomModel) {
        String version = StringUtils.isNotBlank((CharSequence)pomModel.getVersion()) ? pomModel.getVersion() : pomModel.getParent().getVersion();
        return new BundleDescriptor.Builder().setGroupId(StringUtils.isNotBlank((CharSequence)pomModel.getGroupId()) ? pomModel.getGroupId() : pomModel.getParent().getGroupId()).setArtifactId(pomModel.getArtifactId()).setVersion(version).setBaseVersion(version).setType(POM_TYPE).build();
    }
}

