/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.MuleArchiver;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.structure.FolderNames;

public class PackageBuilder {
    private File classesFolder = null;
    private File repositoryFolder = null;
    private File mavenFolder = null;
    private File muleSrcFolder = null;
    private File muleArtifactFolder = null;
    private List<File> rootResources = new ArrayList<File>();
    private File destinationFile;
    private MuleArchiver archiver = null;

    public MuleArchiver getMuleArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }

    public PackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkNotNull((Object)((Object)archiver), (Object)"The org.mule.tools.artifact.org.mule.tools.artifact.archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    public PackageBuilder withClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.classesFolder = folder;
        return this;
    }

    public PackageBuilder withMaven(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.mavenFolder = folder;
        return this;
    }

    public PackageBuilder withMuleSrc(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleSrcFolder = folder;
        return this;
    }

    public PackageBuilder withMuleArtifact(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleArtifactFolder = folder;
        return this;
    }

    public PackageBuilder withRepository(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.repositoryFolder = folder;
        return this;
    }

    public PackageBuilder withRootResource(File resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The resource must not be null");
        this.rootResources.add(resource);
        return this;
    }

    public PackageBuilder withDestinationFile(File file) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"The file must not be null");
        Preconditions.checkArgument((!file.exists() ? 1 : 0) != 0, (Object)"The file must not be duplicated");
        this.destinationFile = file;
        return this;
    }

    public PackageBuilder fromWorkingDirectory(Path workingDirectory) {
        return this.withClasses(workingDirectory.resolve(FolderNames.CLASSES.value()).toFile()).withMaven(workingDirectory.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MAVEN.value()).toFile()).withMuleArtifact(workingDirectory.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile()).withMuleSrc(workingDirectory.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_SRC.value()).toFile()).withRepository(workingDirectory.resolve(FolderNames.REPOSITORY.value()).toFile());
    }

    public void createDeployableFile() throws IOException {
        this.runPrePackageValidations();
        MuleArchiver archiver = this.getMuleArchiver();
        if (null != this.classesFolder && this.classesFolder.exists() && this.classesFolder.isDirectory()) {
            archiver.addToRoot(this.classesFolder, null, null);
        }
        if (null != this.mavenFolder && this.mavenFolder.exists() && this.mavenFolder.isDirectory()) {
            archiver.addMaven(this.mavenFolder, null, null);
        }
        if (null != this.muleArtifactFolder && this.muleArtifactFolder.exists() && this.muleArtifactFolder.isDirectory()) {
            archiver.addMuleArtifact(this.muleArtifactFolder, null, null);
        }
        if (null != this.muleSrcFolder && this.muleSrcFolder.exists() && this.muleSrcFolder.isDirectory()) {
            archiver.addMuleSrc(this.muleSrcFolder, null, null);
        }
        if (null != this.repositoryFolder && this.repositoryFolder.exists() && this.repositoryFolder.isDirectory()) {
            archiver.addRepository(this.repositoryFolder, null, null);
        }
        archiver.setDestFile(this.destinationFile);
        archiver.createArchive();
    }

    public void createMuleApp(File destinationFile, String originFolder, PackagingType packagingType, boolean onlyMuleSources, boolean lightweightPackage, boolean attachMuleSources) throws ArchiverException, IOException {
        Path originFolderPath = Paths.get(originFolder, new String[0]);
        Path metaInfPath = originFolderPath.resolve(FolderNames.META_INF.value());
        PackageBuilder builder = this.withDestinationFile(destinationFile);
        if (!onlyMuleSources) {
            builder.withClasses(originFolderPath.resolve(FolderNames.CLASSES.value()).toFile()).withMaven(metaInfPath.resolve(FolderNames.MAVEN.value()).toFile()).withMuleArtifact(metaInfPath.resolve(FolderNames.MULE_ARTIFACT.value()).toFile());
            if (!lightweightPackage) {
                builder.withRepository(originFolderPath.resolve(FolderNames.REPOSITORY.value()).toFile());
            }
            if (attachMuleSources) {
                builder.withMuleSrc(metaInfPath.resolve(FolderNames.MULE_SRC.value()).toFile());
            }
        } else {
            builder.withMuleSrc(metaInfPath.resolve(FolderNames.MULE_SRC.value()).toFile());
        }
        builder.createDeployableFile();
    }

    private void runPrePackageValidations() {
        Preconditions.checkArgument((this.destinationFile != null ? 1 : 0) != 0, (Object)"The destination file has not been set");
    }
}

