/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.module.reader.FileSourceProvider;
import org.mule.weave.v2.module.reader.FileSourceProvider$;
import org.mule.weave.v2.module.reader.InputStreamSourceProvider;
import org.mule.weave.v2.module.reader.InputStreamSourceProvider$;
import org.mule.weave.v2.module.reader.JavaObjectSourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.StringSourceProvider;
import org.mule.weave.v2.module.reader.StringSourceProvider$;
import scala.None$;
import scala.Option;
import scala.Some;

public final class SourceProvider$ {
    public static SourceProvider$ MODULE$;

    static {
        new SourceProvider$();
    }

    public SourceProvider apply(File file, Charset charset) {
        return new FileSourceProvider(file, charset, FileSourceProvider$.MODULE$.$lessinit$greater$default$3());
    }

    public SourceProvider apply(String str) {
        return new StringSourceProvider(str, StringSourceProvider$.MODULE$.$lessinit$greater$default$2());
    }

    public SourceProvider apply(InputStream is, Charset charset) {
        return new InputStreamSourceProvider(is, charset, InputStreamSourceProvider$.MODULE$.$lessinit$greater$default$3());
    }

    public SourceProvider apply(InputStream is, Charset charset, MimeType mediaType) {
        return new InputStreamSourceProvider(is, charset, (Option<MimeType>)new Some((Object)mediaType));
    }

    public SourceProvider apply(Object source, Charset charset) {
        return this.apply(source, charset, (Option<MimeType>)None$.MODULE$);
    }

    public SourceProvider apply(Object source, Charset charset, Option<MimeType> mediaType) {
        SourceProvider sourceProvider;
        Object object = source;
        if (object instanceof String) {
            String string = (String)object;
            sourceProvider = new StringSourceProvider(string, mediaType);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            sourceProvider = new InputStreamSourceProvider(new ByteArrayInputStream(byArray), charset, mediaType);
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            sourceProvider = new InputStreamSourceProvider(inputStream, charset, mediaType);
        } else if (object instanceof File) {
            File file = (File)object;
            sourceProvider = new FileSourceProvider(file, charset, mediaType);
        } else {
            sourceProvider = new JavaObjectSourceProvider(source, mediaType);
        }
        return sourceProvider;
    }

    public SourceProvider apply(Object source) {
        SourceProvider sourceProvider;
        Object object = source;
        SourceProvider sourceProvider2 = object instanceof SourceProvider ? (sourceProvider = (SourceProvider)object) : this.apply(source, Charset.forName("UTF-8"));
        return sourceProvider2;
    }

    private SourceProvider$() {
        MODULE$ = this;
    }
}

