/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSImplementationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSLoaderImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.LSInputListImpl;
import com.sun.org.apache.xerces.internal.xs.XSLoader;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.mule.metadata.xml.utils.XmlSchemaUtils;
import org.w3c.dom.ls.LSInput;

public class ModelFactory {
    private XSModel model;
    private Optional<QName> rootElementName;
    private Optional<ExampleAnnotation> example;

    private ModelFactory(XSModel model, ExampleAnnotation example, QName rootElementName) {
        this.model = model;
        this.example = Optional.ofNullable(example);
        this.rootElementName = Optional.ofNullable(rootElementName);
    }

    public XSModel getModel() {
        return this.model;
    }

    public Optional<QName> getRootElementName() {
        return this.rootElementName;
    }

    public Optional<ExampleAnnotation> getExample() {
        return this.example;
    }

    public static ModelFactory fromExample(File exampleFile) {
        try {
            return ModelFactory.fromExample(Files.readAllLines(exampleFile.toPath()).stream().collect(Collectors.joining()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromExample(String exampleXML) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            List<String> schemas = SchemaHelper.generateXSD(exampleXML);
            LSInput[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> new DOMInputImpl(null, null, null, new StringReader((String)schema), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            Optional<QName> rootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(schemas, exampleXML);
            return new ModelFactory(model, new ExampleAnnotation(StringEscapeUtils.escapeXml11((String)exampleXML)), rootElementName.orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromSchemas(Map<String, InputStream> schemasMap) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            XSLoaderImpl myLoader = (XSLoaderImpl)schemaLoader;
            ArrayList errors = new ArrayList();
            myLoader.setParameter("error-handler", error -> {
                errors.add(error.getMessage());
                return false;
            });
            LSInput[] domInputs = (DOMInputImpl[])schemasMap.entrySet().stream().map(schema -> new DOMInputImpl(null, (String)schema.getKey(), null, (InputStream)schema.getValue(), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            if (model == null) {
                throw new RuntimeException("Failed while trying to load schema errors " + errors.stream().reduce("", (value, acc) -> value + ", " + acc));
            }
            return new ModelFactory(model, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XSLoader initializeXSLoader() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        XSImplementationImpl impl = new XSImplementationImpl();
        return impl.createXSLoader(null);
    }
}

